# SimpleScalar Visualization Engine
# Menu Bar Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#
# Menubar options:
#
option add *Menubar.borderWidth 2      widgetDefault
option add *Menubar.relief      raised widgetDefault

set helpText1 "
 \
           Commands available from the Options Menu in Elm 2.4 \
 \
  y     Your full name to be used in outbound mail. \
 \
  z     Insert dashes before signature. "
#-----------------------------------------------------------------------#
# Function definitions:
#
proc execCommand {p0 p1 p2 p3} {

    global OPTIONS
    # puts "command path: $p0"
    # puts "benchmark path: $p1"
    # puts "input file: $p2"
    # puts "options: $p3"
    if {$p3 == 666} {
	if {[info exists OPTIONS]}  {
		set p3 $OPTIONS
	} else {
	    unset p3
	}
    }
    set bindex [string last / $p1]
    set bench_file [string range $p1 $bindex end]
    set bench_file [string trimleft $bench_file /]
    set bench_file [string toupper $bench_file]
    set bindex [string first . $bench_file]
    set bench_file [string range $bench_file 0 [expr $bindex - 1]]
    set bigmess "Restart SimpleScalar with the $bench_file benchmark?"
    set ans [tk_messageBox \
	    -icon question \
	    -type okcancel \
	    -message "$bigmess" \
	    -parent . \
	    -title "Load $bench_file Benchmark..." ]
    if {[string compare $ans "ok"]} {
	# why does this conditional work the opposite
	# of the way it is supposed to?
	return 0
    }
    #
    # NOTE: The syntax for the EXEC command is very tricky,
    # so please be careful when touching the following line:
    #
    set Script "exec $p0 $p1"
    if {[info exists p2]} {
	set Script [concat $Script " " $p2]
    }
    if {[info exists p3]} {
	set Script [concat $Script " " $p3]
    }
    set Script [concat $Script " &"]
    # puts "Do this: $Script"
    eval $Script
    exit
    # exec $p0 $p1 $p2 $p3 &
}

set ExecutablePathname  ""
proc menubar_create {window} {
    global activeMenuBackground
    global ExecutablePathname 
    frame $window -class Menubar

    set settings $window.settings.menu
    set help $window.help.menu
    set graphs $window.graphs.menu
    set statistics $window.statistics.menu

    menubutton $window.settings -menu $settings \
	-activebackground "$activeMenuBackground" \
	-text "Benchmarks"
    menubutton $window.help -menu $help \
	-activebackground "$activeMenuBackground" \
	-text "Help"
    menubutton $window.graphs -menu $graphs \
	-activebackground "$activeMenuBackground" \
	-text "Graphs"
    menubutton $window.statistics -menu $statistics -text "Statistics"

    menu $settings -tearoff no
    menu $help -tearoff no
    menu $graphs -tearoff no
    menu $statistics -tearoff no

    #-------------------------------------------------------------------#
    # Settings menu handles settings files:
    #
    set SpecDir "/p/bin/simplescalar/spec95/"
    set BenchmarkDir ${SpecDir}benchmarks/

    # set BASE_DIR "/local/cartel/ss-viz/"
    #
    # These global vars were set in the ss-viz/ss-vizd and sstk chain
    global APP_NAME
    global BASE_DIR
    #
    set ExecutablePathname ${BASE_DIR}/${APP_NAME}
    # puts "My Executable Pathname? $ExecutablePathname"
    #
    # For the production version:
    # set ExecutablePathname ${BASE_DIR}ss-viz
    #
    # For the debuggable version:
    # set ExecutablePathname ${BASE_DIR}ss-vizd

    set CompressParam1 "${BenchmarkDir}compress95.ss"
    set CompressParam2 "${SpecDir}inputs/129.compress/test/test.in"

    set CompressTrainParam1 "${BenchmarkDir}compress95.ss"
    set CompressTrainParam2 "${SpecDir}inputs/129.compress/train/test.in"
    set MgridParam1 "${BenchmarkDir}mgrid.ss"
    set MgridParam2 "${SpecDir}inputs/107.mgrid/test/mgrid.2it.in"

    set GccParam1 "${BenchmarkDir}cc1.ss"
    set GccParam2 "${SpecDir}inputs/126.gcc/test/genoutput.i"

    set FppppParam1 "${BenchmarkDir}fpppp.ss"
    set FppppParam2 "${SpecDir}inputs/145.fpppp/train/natoms.in"

    set optionsParam "666"

    $settings add command -underline 0 -label "Load Benchmark..." \
	    -activebackground "$activeMenuBackground" \
	     -command [list take_run_command $window]

    $settings add separator

    $settings add command -underline 0 -label "Compress Benchmark" \
	    -activebackground "$activeMenuBackground" \
	     -command "execCommand $ExecutablePathname $CompressParam1 $CompressParam2 $optionsParam"

    $settings add command -underline 9 -label "Compress Train Benchmark" \
	    -activebackground "$activeMenuBackground" \
	     -command "execCommand $ExecutablePathname $CompressTrainParam1 $CompressTrainParam2 $optionsParam"

    $settings add command -underline 0 -label "Fpppp Benchmark" \
	    -activebackground "$activeMenuBackground" \
	     -command "execCommand $ExecutablePathname $FppppParam1 $FppppParam2 $optionsParam"

    $settings add command -underline 0 -label "Gcc Benchmark" \
	-activebackground "$activeMenuBackground" \
	 -command "execCommand $ExecutablePathname $GccParam1 $GccParam2 $optionsParam"

    $settings add command -underline 0 -label "Mgrid Benchmark" \
	-activebackground "$activeMenuBackground" \
	 -command "execCommand $ExecutablePathname $MgridParam1 $MgridParam2 $optionsParam"

    $settings add command -underline 1 -label "Exit" \
	    -activebackground "$activeMenuBackground" \
	    -command [list menubar_exit .status]

    #-------------------------------------------------------------------#
    # Help menu displays useful information:
    #
    $help add command -underline 0 -label "Help Topics" \
	    -activebackground "$activeMenuBackground" \
	     -command [list launchNetscape index "Visualizer Help"]
    $help add command -underline 0 -label "About SimpleScalar Visualizer..." \
	    -activebackground "$activeMenuBackground" \
	    -command [list menubar_helpShow $window about ]

    #-------------------------------------------------------------------#
    # graphs menu has links to observe several parameters dynamically:
    # 
     # $graphs add command -label "All Graphs" -command {
 	# display_graph ipc "Unk" "Unk"
 	# display_graph dl1misses "Unk" "Unk"
 	# display_graph il1misses "Unk" "Unk"
 	# display_graph bpredict "Unk" "Unk"
     # }
    $graphs add command -label "IPC Graph" \
	    -activebackground "$activeMenuBackground" \
	    -command { display_graph "ipc" "Unk" "Unk"}

    $graphs add command -label "DL1 Miss Rate Graph" \
	    -activebackground "$activeMenuBackground" \
	    -command { display_graph "dl1misses" "Unk" "Unk"}
    
    $graphs add command -label "IL1 Miss Rate Graph"  \
	    -activebackground "$activeMenuBackground" \
	    -command { display_graph "il1misses" "Unk" "Unk"}

    $graphs add command -label "Branch Prediction Graph"  \
	    -activebackground "$activeMenuBackground" \
	    -command { display_graph "bpredict" "Unk" "Unk"}

     $graphs add command -label "Close Graphs" -command {
 	hide_graph ipc
 	hide_graph dl1misses
 	hide_graph il1misses
 	hide_graph bpredict
     }

    #-------------------------------------------------------------------#
    # Statistics.  Strictly alphabetized
    # 
     $statistics add command -label "All Statistics" -command {
 	display_statistics "branch prediction" "Unk" "Unk" 0
 	display_statistics dl1 "Unk" "Unk" 0
 	display_statistics dtlb "Unk" "Unk" 0
 	display_statistics ifq "Unk" "Unk" 0
 	display_statistics il1 "Unk" "Unk" 0
 	display_statistics itlb "Unk" "Unk" 0
 	display_statistics lsq "Unk" "Unk" 0
 	display_statistics misc "Unk" "Unk" 0
 	display_statistics ruu "Unk" "Unk" 0
	# by this time, we should wrap to the top of the screen
 	display_statistics sys "Unk" "Unk" 0
     }
     $statistics add command -label "Branch Prediction Statistics" -command {
 	display_statistics "branch prediction" "Unk" "Unk" 0
     }
     $statistics add command -label "DL1 Statistics" -command {
 	display_statistics dl1 "Unk" "Unk" 0
     }
     $statistics add command -label "DTLB Statistics" -command {
 	display_statistics dtlb "Unk" "Unk" 0
     }
     $statistics add command -label "IFQ Statistics" -command {
 	display_statistics ifq "Unk" "Unk" 0
     }
     $statistics add command -label "IL1 Statistics" -command {
 	display_statistics il1 "Unk" "Unk" 0
     }
     $statistics add command -label "ITLB Statistics" -command {
 	display_statistics itlb "Unk" "Unk" 0
     }
     $statistics add command -label "LSQ Statistics" -command {
 	display_statistics lsq "Unk" "Unk" 0
     }
     $statistics add command -label "Memory Statistics" -command {
 	display_statistics misc "Unk" "Unk" 0
     }
     $statistics add command -label "RUU Statistics" -command {
 	display_statistics ruu "Unk" "Unk" 0
     }
     # $statistics add command -label "L2 Statistics" -command {
	 # display_statistics ul2 "Unk" "Unk" 0
     # }
     $statistics add command -label "System Statistics" -command {
 	display_statistics sys "Unk" "Unk" 0
     }
     $statistics add command -label "Close Statistics" -command {
 	hide_statistics "branch prediction"
 	hide_statistics dl1
 	hide_statistics dtlb 
 	hide_statistics ifq 
 	hide_statistics il1 
 	hide_statistics itlb 
 	hide_statistics lsq 
 	hide_statistics misc 
 	hide_statistics ruu 
 	hide_statistics sys 
     }
     
    pack $window.settings -side left
    pack $window.graphs -side left
    pack $window.statistics -side left
    pack $window.help -side right

    return $window
}

#-----------------------------------------------------------------------#
# Settings commands:
#
proc menubar_exit {status} {
    global unitSetting GraphNames ThumbsFor

    # status_message $status "Exiting..."

    set confirm \
	[tk_messageBox \
	    -default no \
	    -icon warning \
	    -message "Exit the SimpleScalar Visualizer?" \
	    -parent . \
	    -title "Exit Dialog" \
	    -type yesno]

    if {[string equal $confirm "yes"]} {
	exit
    }
    return $status
}

proc menubar_loadConfig {status} {
    global unitSetting

    lappend command tk_getOpenFile
    lappend command -defaultextension .ss
    lappend command -filetypes {{"SimpleScalar File" {.ss}}}

    if {[info exists unitSetting(LOADFILE)]} {
	lappend command -initialfile $unitSetting(LOADFILE)
    }

    lappend command -parent .
    lappend command -title "Load Benchmark Dialog"

    status_message $status "Load Benchmark Dialog" 
    set filename [eval $command]
    
    if {[string length $filename] > 0} {
	if {[catch {unitset_reader $filename} message]} {
	    status_message $status "Error while reading: $message"
	} else {
	    status_message $status "Read settings from $filename"
	}
	set unitSetting(LOADFILE) $filename
    }

    return $status
}

proc menubar_saveConfig {status} {
    global unitSetting

    lappend command tk_getSaveFile
    lappend command -defaultextension .ssv
    lappend command -filetypes {{"SimpleScalar Visualization File" {.ssv}}}

    if {[info exists unitSetting(SAVEFILE)]} {
	lappend command -initialfile $unitSetting(SAVEFILE)
    }

    lappend command -parent .
    lappend command -title "Save Settings Dialog"

    status_message $status "Save settings dialog" 
    set filename [eval $command]
    
    if {[string length $filename] > 0} {
	if {[catch {unitset_writer $filename} message]} {
	    status_message $status "Error while writing: $message"
	} else {
	    catch [unset unitSetting(MODIFIED)]
	    status_message $status "Wrote settings to $filename"
	}
	set unitSetting(SAVEFILE) $filename
    }

    return $status
}

proc menubar_helpShow {window option} {
    global helpText1 
    global engine_version 
    global ss_version

    switch -exact $option {

	about { 
	    # set mess1 "The SimpleScalar Visualization Engine:\n\n"
	    set mess1 ""
	    set mess2 "Copyright (c) 2000, 2001.\n\n"
	    set mess3 "SuperScalar Out-of-Order Processor Simulator, Version ${ss_version}.\n"
	    set mess4 "SimpleScalar Graphical User Interface, Version ${engine_version}.\n\n"
	    set mess5 "Licensed to the University of Texas Computer Architecture and Technology Laboratory (CART)."
	    set bigmess [concat $mess1 $mess2 $mess3 $mess4 $mess5]
	    tk_messageBox \
		    -icon info \
		    -message "$bigmess" \
		    -parent . \
		    -title "About SimpleScalar Visualizer" \
		    -type ok
	    
	}
	terms {
		display_help_text $window "elm-help" "Help: Terms"
	}
	org_terms {

	    tk_messageBox \
		    -icon info \
		    -message "$helpText1" \
		    -parent . \
		    -title "Terms" \
		    -type ok

	}

	overview {

	    tk_messageBox \
		    -icon info \
		    -message "SS Visualization is a tool for observing several architectural parameters graphically while executing a benchmark using SimpleScalar." \
		    -parent . \
		    -title "Overview" \
		    -type ok

	}

    }

}
proc take_run_command {label} {

    global APP_NAME
    global BENCHMARK_PATH
    global COMESFROM_PATH
    global OPTIONS
    global OUTPUT_PATH

    set Option "benchmarkLine"
    set Option1 "inputPath"
    set Option2 "simOps"
    set Option3 "outputPath"

    set OptionText "Benchmark Path:"
    set Option1Text "Input Path:"
    set Option2Text "Simulator Options:"
    set Option3Text "Results Path:"

    toplevel ${label}.configwin
    set DisplayFrame "${label}.configwin.datafr"
    set ButtonFrame "${label}.configwin.buttonfr"
    frame $DisplayFrame -relief flat

    label "${DisplayFrame}.${Option}_lab" -justify right -text $OptionText
    entry "${DisplayFrame}.${Option}_ent" -width 55 -justify left
    "${DisplayFrame}.${Option}_ent" insert 0 $BENCHMARK_PATH 

    label "${DisplayFrame}.${Option1}_lab" -justify right -text $Option1Text
    entry "${DisplayFrame}.${Option1}_ent" -width 55 -justify left
    "${DisplayFrame}.${Option1}_ent" insert 0 $COMESFROM_PATH

    label "${DisplayFrame}.${Option2}_lab" -justify right -text $Option2Text
    entry "${DisplayFrame}.${Option2}_ent" -width 55 -justify left
    "${DisplayFrame}.${Option2}_ent" insert 0 $OPTIONS

    label "${DisplayFrame}.${Option3}_lab" -justify right -text $Option3Text
    entry "${DisplayFrame}.${Option3}_ent" -width 55 -justify left
    "${DisplayFrame}.${Option3}_ent" insert 0 $OUTPUT_PATH

    frame $ButtonFrame -relief groove -borderwidth 2

    button $ButtonFrame.ok -text "OK" -command [list save_run_data \
	    $label $DisplayFrame]

    button $ButtonFrame.cancel -text "Cancel" \
	    -command [list set conf_close 0]

    set Row 0
    set Column 0
    set conf_close 1

    grid config "${DisplayFrame}.${Option}_lab" \
	    -row $Row -column $Column
    set Column [expr $Column+1]
    grid config "${DisplayFrame}.${Option}_ent"\
	    -row $Row -column $Column
    set Row [expr $Row+1]

    set Column 0
    grid config "${DisplayFrame}.${Option1}_lab" \
	    -row $Row -column $Column
    set Column [expr $Column+1]
    grid config "${DisplayFrame}.${Option1}_ent"\
	    -row $Row -column $Column
    set Row [expr $Row+1]

    set Column 0
    grid config "${DisplayFrame}.${Option2}_lab" \
	    -row $Row -column $Column
    set Column [expr $Column+1]
    grid config "${DisplayFrame}.${Option2}_ent"\
	    -row $Row -column $Column
    set Row [expr $Row+1]

    set Column 0
    grid config "${DisplayFrame}.${Option3}_lab" \
	    -row $Row -column $Column
    set Column [expr $Column+1]
    grid config "${DisplayFrame}.${Option3}_ent"\
	    -row $Row -column $Column
    set Row [expr $Row+1]

    grid configure $ButtonFrame.ok $ButtonFrame.cancel
    
    pack $DisplayFrame $ButtonFrame -side top

    wm title "${label}.configwin" "Benchmark Information"

    tkwait variable conf_close
    destroy ${label}.configwin

}
proc save_run_data {label Display} {
    global ExecutablePathname 
    global OUTPUT_PATH

    set Option "benchmarkLine"
    set Option1 "inputPath"
    set Option2 "simOps"
    set Option3 "outputPath"

    set benchmark [${Display}.${Option}_ent get]
    set inputPath [${Display}.${Option1}_ent get]
    set simOps [${Display}.${Option2}_ent get]
    set outputPath [${Display}.${Option3}_ent get]

    # puts "benchmark: $benchmark"
    # puts "inputPath: $inputPath"
    # puts "simOps: $simOps"
    # puts "outputPath: $outputPath"
    if {[string compare $OUTPUT_PATH $outputPath] != 0} {
	# save the user's desired output path
	set baseNameIndex [string last "/" $OUTPUT_PATH]
	set baseName [string range $OUTPUT_PATH \
			[expr $baseNameIndex + 1] "end"]
        # puts "baseName is $baseName"
        set newFilePathName "/tmp/.${baseName}"
	set f [open "$newFilePathName" "w"]
	puts $f "$outputPath"
	close $f
    }
    execCommand $ExecutablePathname $benchmark $inputPath $simOps
}
