# SimpleScalar Visualization Engine
# Popup display Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

# Certain global variables to control the way popups act.

global PopupActOrDeact

# Initializes any variables or functions that might be needed by the popup
# facility.

proc init_popup {} {
    # puts "init_popup: here"

    global unitList ThumbsFor
    global PopupActOrDeact

    foreach name $unitList {
	
	switch -regexp -- $name {
	    
	    ^box:[^\/]*$ {

		regexp -- {^box:(.*)$} $name whole unit

		if { ! [info exists PopupActOrDeact($unit)] && \
		    [lsearch -exact $ThumbsFor $unit] != -1 } {

		    set PopupActOrDeact($unit) "Activate Thumbnail"

		}

	    }
	    
	}

    }

}

# The actual function that is called whenever the right mouse button is
# clicked.

proc popup {window localx localy canvas} {
    # puts "popup: here"

}
proc old_popup {window localx localy canvas} {

    global PopupActOrDeact ThumbsFor

    set gx [winfo rootx $window]
    set gy [winfo rooty $window]
    set mx [expr $gx + $localx]
    set my [expr $gy + $localy]

    # Get the name of the unit on which the mouse button was clicked.

    set id [$canvas find closest $localx $localy]
    set Tags  [$canvas gettags $id]
    set Index [lsearch -regexp $Tags {box:.*\/[0-9]+}]
    if {$Index == -1} {
	set Index [lsearch -regexp $Tags {box:.*}]
    }

    # If the object is not a box, no popup need be displayed.

    if {$Index == -1} {
	return
    }

    # If it is a box, then get the unit name.

    set MyTag [lindex $Tags $Index]

    if {![regexp {box:(.*)\/([0-9]+)} $MyTag EntireString unit ItemNumber]} {
	regexp {box:(.*)} $MyTag EntireString unit
    }

    # If the unit is not among those boxes for which a thumbnail is
    # defined, just display the settings. Else display the popup menu.

    if { [lsearch -exact $ThumbsFor $unit] != -1 } {

	# Create the popup menu and bind its associated actions.

	if { ! [winfo exists .${unit}_popup] } {
	    
	    menu .${unit}_popup -tearoff no
	    
	    # The procedure for activating or deactivating the thumbnail.
	    
	    .${unit}_popup add command -label $PopupActOrDeact($unit) \
		    -command [list ToggleThumbnail $canvas $unit]
	    
	    # The settings for that unit are popped up. Disabled for now.
	    
#	    .${unit}_popup add command -label "Settings..." -command \
#		    [list unit_setting $canvas $localx $localy]
	    
	}

	tk_popup .${unit}_popup $mx $my

    } else {

	# Settings for that unit are disabled now.

#	unit_setting $canvas $localx $localy

    }
    
}

# The procedure that actually displays or hides the thumbnail as the case
# may be.

proc ToggleThumbnail {canvas unit} {
    # puts "ToggleThumbnail: here"
}
proc OldToggleThumbnail {canvas unit} {
    
    global PopupActOrDeact

    if { [string compare $PopupActOrDeact($unit) "Activate Thumbnail"] \
	    == 0 } {

	# Activate the thumbnail for the unit alone.
	
	display_thumbnail $unit 0

	set PopupActOrDeact($unit) "Deactivate Thumbnail"
	destroy .${unit}_popup

    } else {

	# Deactivate the thumbnail for that unit alone.
	
	deact_thumbnail $unit

	set PopupActOrDeact($unit) "Activate Thumbnail"
	destroy .${unit}_popup

    }
}



