# SimpleScalar Visualization Engine
# SimpleScalar Interface Functions (stubs version)
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#
if {![info exists ::ss_version] && [catch {package require Ss} ::ss_version]} {

    package provide Ss 1.2
    puts "HOWDY"
    
    namespace eval ::ss:: {

	variable opt_fetch_ifqsize	4
	variable opt_ruu_size	        64
	variable opt_lsq_size	        32

	variable opt_res_fpalu	        3
	variable opt_res_fpmult	        1
	variable opt_res_ialu	        4
	variable opt_res_imult	        1
	variable opt_bpred              ""

	variable stat_sim_cycle	        0 # Simulation cycles till now

	namespace export getOption
	namespace export getStatistic
	namespace export isOption
	namespace export isStatistic
	# namespace export listOption
	namespace export listStatistic
	# namespace export setOption
	namespace export setStatistic
	namespace export step
	namespace export getIFQItem
	namespace export getIFQItems
	namespace export getRUUItems
	namespace export getLSQItems
	namespace export getFUItems
    }

    #-----------------------------------------------------------------------#

    proc ::ss::getOption {option} {
	if {! [::ss::isOption $option]} {
	    error "invalid option name: ${option}"
	}

	set abbr [string map {: _} [string trimleft $option "-"]]

	eval return "\$::ss::opt_${abbr}"
    }

    proc ::ss::getStatistic {statistic} {
        puts "get statistic"
	if {! [::ss::isStatistic $statistic]} {
	    error "invalid statistic name: ${statistic}"
	}

	eval return "\$::ss::stat_${statistic}"
    }

    proc ::ss::setStatistic {statistic value} {

	if {! [::ss::isStatistic $statistic] } {
	    error "invalid statistic name : $statistic"
	}

	eval return "set ::ss::stat_${statistic} \$value"

    }

    proc ::ss::isOption {option} {
	if {! [regexp -- {-[[:alnum:]_:]+} $option]} {
	    return 0
	}

	set abbr [string map {: _} [string trimleft $option "-"]]

	return [info exists "::ss::opt_${abbr}"]
    }

    proc ::ss::isStatistic {statistic} {
	
	return [info exists "::ss::stat_${statistic}"]

    }

    proc ::ss::listStatistic {} {
	set statlist {}
	foreach var [info vars ::ss::stat_*] {
	    regexp -- {^::ss::stat_(.*)$} $var temp part
	    lappend statlist $part
	}

	return $statlist
    }

    proc ::ss::step {count} {
	variable stat_sim_cycle

	# puts "In proc ss::step in ss_interface.tcl."

	set limit [expr {$stat_sim_cycle+$count}]
	if {$limit > 1100} {
	    set limit 1100
	}

	if {$count >= 2} {
	    set dn [expr {int($count/2.0)}]
	    set up [expr {$count-$dn}]
	    set check [expr {int($stat_sim_cycle+$dn+$up*rand())}]
	    if {$limit > $check} {
		set limit $check
	    }
	}

	set steps [expr {$limit-$stat_sim_cycle}]
	set stat_sim_cycle $limit

	return $steps
    }

    # The default proc returns the IFQ slot number itself.

    proc ::ss::getIFQItem {SlotNum} {
	return $SlotNum
    }
    # The default proc returns the RUU slot number itself.
    proc ::ss::getRUUItems {SlotNum} {
	return $SlotNum
    }
    # The default proc returns the LFQ slot number itself.
    proc ::ss::getLFQItems {SlotNum} {
	return $SlotNum
    }

    # The default proc returns the LFQ slot number itself.
    proc ::ss::getFUItems {SlotNum} {
	return $SlotNum
    }
    set ::ss_version "1.0/stubs"
}


