# SimpleScalar Visualization Engine
# Statistics History Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#

global StatisticsFor

proc stat_init {database cycle} {

    global StatisticsFor
    set StatisticsFor [list itlb dtlb il1 dl1 "branch prediction" misc \
	    sys ifq ruu lsq]

    upvar $database history
    upvar $cycle CycleHistory

    set count 0
    set CycleHistory [ss::getStatistic "sim_cycle"]
    foreach entry [ss::listStatistic] {
	set statistic [lindex $entry 0]
	set history($statistic) [ss::getStatistic $statistic]
	# puts "stat.tcl 1: $statistic"
	incr count
    }

    return $count
}

proc stat_collect {database cycle} {
    upvar $database history
    upvar $cycle CycleHistory

    lappend CycleHistory [ss::getStatistic "sim_cycle"]
    foreach statistic [array names history] {
	if {[catch {ss::getStatistic $statistic} value]} {
	    set value {}
	}
	lappend history($statistic) $value
    }

    if {[catch {llength $history(sim_cycle)} length]} {
	return 0
    }

    return $length
}

proc stat_delta {database statistic {last -1} {prev -2}} {
    upvar $database history

    return \
	[expr \
	    {[stat_value history $statistic $last] \
	     - [stat_value history $statistic $prev]}]
}

proc stat_value {database statistic {offset -1}} {
    upvar $database history
    
    if {$offset >= 0} {
	return [lindex $history($statistic) $offset]
    }

    set size [llength $history($statistic)]

    return [lindex $history($statistic) [expr {$size+$offset}]]
}

proc stat_cycle {database {offset -1}} {
    upvar $database cycledb

    if {$offset >= 0} {
	return [lindex $cycledb $offset]
    }

    set size [llength $cycledb]

    return [lindex $cycledb [expr {$size+$offset}]]

}
proc hide_statistics {label} {
    if { [winfo exists .${label}_stat] } {
	# wm withdraw .${label}_stat 
	destroy .${label}_stat 
	update idletasks
	update
    }
}
# Displays statistics for the hardware 'label'. 
# If 'crank_turned' is 0, this function was invoked from the
# toolbar. If crank_turned is 1, it was invoked from
# stepper.tcl to update the stats.

set xOffset "-10"
set yOffset 4
proc display_statistics {label posx posy crank_turned} {

    global xOffset
    global yOffset
    global statBackground 
    global statForeground

    # An ugly way to get the answer:
    set unknown [expr [eval string compare $posx "Unk"] == 0]
    set def   [expr [ info exists posx]]
    set undef [expr !$def]
    if {$unknown || $undef} {
	set X $xOffset
    }
    # *whew* do it again:
    set unknown [expr [eval string compare $posy "Unk"] == 0]
    set def   [expr [ info exists posy]]
    set undef [expr !$def]
    if {$unknown || $undef} {
	set Y +${yOffset}
    }
    set nextWindowPlacement 100
    set Name $label
    # puts "my name (label) is $label"

    # Get the names of the statistics to be displayed.

    set accesses "${Name}.accesses"
    set hits "${Name}.hits"
    set misses "${Name}.misses"
    set writebacks "${Name}.writebacks"
    set replacements "${Name}.replacements"
    set invalidations "${Name}.invalidations"
    set missrate "${Name}.miss_rate"
    set replrate "${Name}.repl_rate"
    set wbrate "${Name}.wb_rate"
    set invrate "${Name}.inv_rate"

    set Stats [list accesses hits misses writebacks replacements \
	    invalidations missrate replrate wbrate invrate]

    # Display names for each of the above statistics.

    set DisplayName("stat_${label}_accesses") Accesses
    set DisplayName("stat_${label}_hits") Hits
    set DisplayName("stat_${label}_misses") Misses
    set DisplayName("stat_${label}_writebacks") Writebacks
    set DisplayName("stat_${label}_replacements") Replacements
    set DisplayName("stat_${label}_invalidations") Invalidations
    set DisplayName("stat_${label}_missrate") "Miss Rate"
    set DisplayName("stat_${label}_replrate") "Replacement Rate"
    set DisplayName("stat_${label}_wbrate") "Writeback Rate"
    set DisplayName("stat_${label}_invrate") "Invalidation Rate"

    # Determine the name of the actual unit.
    # Begin by setting the wm Title to first name match,

    set Title $Name  

    # puts "my name is $Name"
    switch -exact $label {
	itlb { 
		set Title "ITLB"
        }
	dtlb { 
		set Title "DTLB"
        }
	il1 { 
	    set Title "IL1 Cache"
	}
	dl1 { 
	    set Title "DL1 Cache"
	}
        "branch prediction" {
	    # Special statistics for the Branch Predictor.
	    set Title "Branch Prediction"
	
	    set Name [ss::getOption "-bpred"]
	    set Name "bpred_${Name}"
	
	    set lookups "${Name}.lookups"
	    set misses "${Name}.misses"
	    set updates "${Name}.updates"
	    set addrhits "${Name}.addr_hits"
	    set dirhits "${Name}.dir_hits"
	    set addrrate "${Name}.bpred_addr_rate"
	    set dirrate "${Name}.bpred_dir_rate"
	
	    set Stats [list lookups misses updates addrhits dirhits \
		    addrrate dirrate]
	    
	    # Display names for each of the above statistics.
	    
	    set DisplayName("stat_${label}_lookups") Lookups
	    set DisplayName("stat_${label}_misses") Misses
	    set DisplayName("stat_${label}_updates") Updates
	    set DisplayName("stat_${label}_addrhits") "Address Hits"
	    set DisplayName("stat_${label}_dirhits") "Direction Hits"
	    set DisplayName("stat_${label}_addrrate") "Address Hit Rate"
	    set DisplayName("stat_${label}_dirrate") "Direction Hit Rate"
        }
        "ifq" -
        "ruu" -
        "lsq" {
	
	    # Statistics for the Instruction Fetch Queue, the 
	    # Register Update Unit and the Load Store Queue.
	    set Title [string toupper $label]
	    set Name NotInvalid
	    set caps [string toupper $label]
	
	    set occupancy ${label}_occupancy
	    set rate ${label}_rate
	    set latency ${label}_latency
	    set full ${label}_full
	    
	    set Stats [list occupancy rate latency full]
	    
	    set DisplayName("stat_${label}_occupancy") \
		    "Avg $caps Occupancy"
	    set DisplayName("stat_${label}_rate") "$caps Dispatch Rate"
	    set DisplayName("stat_${label}_latency") "Avg $caps Latency"
	    set DisplayName("stat_${label}_full") "$caps Full Time(ratio)"
        }
        "sys" {
	    set Title "System"
	    set ipc sim_IPC
	    set cycles sim_cycle
	    set time sim_elapsed_time
	    set instrate sim_inst_rate
	    set ipb sim_IPB
	    set execbw sim_exec_BW
	    set cnuminsts sim_num_insn
	    set enuminsts sim_total_insn
	    set cbranches sim_num_branches
	    set ebranches sim_total_branches
	
	    # List of all the above statistics.
	
	    set Stats [list ipc cycles time instrate ipb execbw cnuminsts \
		enuminsts \
		cbranches ebranches]
	    
	    # Display names for each of the above statistics.
	
	    set DisplayName("stat_${label}_ipc") IPC
	    set DisplayName("stat_${label}_cycles") "Simulation Cycles"
	    set DisplayName("stat_${label}_time") "Elapsed Time"
	    set DisplayName("stat_${label}_instrate") "Inst Exec Rate"
	    set DisplayName("stat_${label}_ipb") "Insts Per Branch"
	    set DisplayName("stat_${label}_execbw") "Exec B/W"
	    set DisplayName("stat_${label}_cnuminsts") "Insts Committed"
	    set DisplayName("stat_${label}_enuminsts") "Insts Executed"
	    set DisplayName("stat_${label}_cbranches") "Branches Committed"
	    set DisplayName("stat_${label}_ebranches") "Branches Executed"
        }
        "misc" {
	    set Title "Memory"
	    set cmemrefs sim_num_refs
	    set ememrefs sim_total_refs
	    set cloads sim_num_loads
	    set eloads sim_total_loads
	    set cstores sim_num_stores
	    set estores sim_total_stores
	
	    # List of all the above statistics.
	
	    set Stats [list \
			cmemrefs ememrefs cloads eloads cstores estores \
		      ]
	    
	    # Display names for each of the above statistics.
	
	    set DisplayName("stat_${label}_cmemrefs") "Mem Refs Committed"
	    set DisplayName("stat_${label}_ememrefs") "Mem Refs Executed"
	    set DisplayName("stat_${label}_cloads") "Loads Committed"
	    set DisplayName("stat_${label}_eloads") "Loads Executed"
	    set DisplayName("stat_${label}_cstores") "Stores Committed"
	    set DisplayName("stat_${label}_estores") "Stores Executed"
        }
    }
    # Display the actual widgets.

    set Title [concat $Title " Statistics"]

    if { [winfo exists .${label}_stat] } {

	# If the statistics window already exists, then just display the 
	# latest figures.

	foreach Stat $Stats {
	    
	    set StatFrame .${label}_stat.${Stat}_frame	    

	    eval set StatName "\$$Stat"
            # puts "312: looking for $StatName"
	    set Value [ss::getStatistic $StatName]

	    if { [string compare $Value ""] == 0 } {

		$StatFrame.${Stat}_value configure -text "Undef "

	    } else {

		set Value [format "%.2f" $Value] 
		$StatFrame.${Stat}_value configure -text $Value

	    }

	}
	wm withdraw .${label}_stat 
	wm deiconify .${label}_stat 
	update idletasks
	update

    } elseif { $crank_turned == 0 } {   

	# If the window doesn't exist and this function isn't
	# invoked by just a normal turn of the crank, then
	# create the window and map it.

	    toplevel .${label}_stat -background $statBackground
	    wm title .${label}_stat $Title
	    # wm transient .${label}_stat .
	    wm group .${label}_stat .
	    
	    # Create the label widgets that show the statistic name and values.
	    foreach Stat $Stats {
		
		set LabelName $DisplayName("stat_${label}_${Stat}")
		frame .${label}_stat.${Stat}_frame -bd 0 -relief flat
		set StatFrame .${label}_stat.${Stat}_frame

		label $StatFrame.$Stat -anchor e -text "$LabelName : " \
			-width 20 -fg $statForeground -bg $statBackground
		label $StatFrame.${Stat}_value -text "Undef" \
			-anchor w -width 12 -fg $statForeground -bg $statBackground
	    }
	    # Pack them properly using the grid configuration manager.
	    # Pack the label widgets in each frame first.
	    foreach Stat $Stats {
		set StatFrame .${label}_stat.${Stat}_frame
		grid config $StatFrame.$Stat -row 0 -column 0
		grid config $StatFrame.${Stat}_value -row 0 -column 1
	    }

	    # Pack each of the frames later.

	    set Row 0
	    set Column 0
	    foreach Stat $Stats {

		set StatFrame .${label}_stat.${Stat}_frame

		grid config $StatFrame -row $Row -column $Column
		set Column [expr $Column+1]

		if { [expr {$Column % 2}] == 0 } {

		    set Column 0
		    set Row [expr $Row+1]
		}
	    }
	    # Set the label widgets to hold the current values of the 
	    # statistic.

	    foreach Stat $Stats {
                # puts "This stat=$Stat"
   
		set StatFrame .${label}_stat.${Stat}_frame

		eval set StatName "\$$Stat"
                # puts "388: looking for $StatName"
		set Value [ss::getStatistic $StatName]

		if { [string compare $Value ""] == 0 } {
		    
		    $StatFrame.${Stat}_value configure -text "Undef "

		} else {

		    set Value [format "%.2f" $Value]
		    $StatFrame.${Stat}_value configure -text $Value

		}
		    
	    }
	    # use X Windows geometry style--always include the
	    # leading minus sign or leading plus sign
	    #
	    # puts "X:$X;Y:$Y."
	    set res [wm geometry .${label}_stat "=$X$Y" ]
	    # $res should be null if the geometry works
	    update idletasks
	    update

	    switch -exact $label {
		"branch prediction" {
		    set nextWindowPlacement 110
		}
		btb {
		    set nextWindowPlacement 100
		}
		ifq { 
		    set nextWindowPlacement 72
		}
		itlb {
		    set nextWindowPlacement 110
		}
		il1 { 
		    set nextWindowPlacement 120
		}
		dl1 { 
		    set nextWindowPlacement 110
		}
		ruu {
		    set nextWindowPlacement 64
		}
		lsq {
		    set nextWindowPlacement 72
		}
		dtlb {
		    set nextWindowPlacement 130
		}
		fnu {
		    set nextWindowPlacement 100
		}
		l2c {
		    set nextWindowPlacement 100
		}
		mem {
		    set nextWindowPlacement 100
		}
		misc {
		    set nextWindowPlacement 92
		}
		sys {
		    set nextWindowPlacement 130
		}
	    default {
		puts "Missed it: $label"
		set nextWindowPlacement 100
	    }
	}
	set screenHigh [winfo vrootheight .]
	# set ylo [winfo rooty .${label}_stat]
	# puts "ylo: $ylo, yOffset: $yOffset"
	# Note that yOffset doesn't take into account
	# the borderwidth of the window frame, but ylo does.
	# Unfortunately, ylo doesn't go beyond the physical screen
	set yhi [expr $yOffset + $nextWindowPlacement]
	set screenOverlap [expr $yhi - $screenHigh]
	set halfNextWindowHeight [expr $nextWindowPlacement * 0.2]
	# puts "overlap: $screenOverlap; half height: $halfNextWindowHeight"
	if { $screenOverlap  > $halfNextWindowHeight } {
	  # time to re-set and re-position at the top of the screen
	  # with a certain offset
	    set yOffset   40
	    set xOffset "-40"
	} else {
	    set yOffset [expr $yOffset + $nextWindowPlacement]
	}
    }
}
proc no_statistics {label title num} {
    set thing "unit"
    if {$num > 1} {
	set thing "units"
    }
    set mess1 ""
    set mess2 "Sorry. There are no statistics for the "
    set mess3 "$title $thing."
    set bigmess [concat $mess1 $mess2 $mess3 ]
    tk_messageBox \
	    -icon info \
	    -message "$bigmess" \
	    -parent . \
	    -title "$title Statistics" \
	    -type ok
}
