# SimpleScalar Visualization Engine
# Status Bar Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#
# Status bar colors:
# 
#
global sbGoColor
global sbGoColor1
global sbStopColor

# Status bar options:
#
option add *Status.borderWidth	  2      widgetDefault
option add *Status.foreground	  black  widgetDefault
option add *Status.relief	  raised widgetDefault

option add *Status.actionSize	  7m     widgetDefault
# option add *Status.goColor0	  white  widgetDefault
# option add *Status.goColor1	  green  widgetDefault
option add *Status.goColor0	  $sbGoColor  widgetDefault
option add *Status.goColor1	  $sbGoColor1  widgetDefault
option add *Status.goMillisec	  10    widgetDefault
option add *Status.spacing	  3      widgetDefault
option add *Status.stopColor	  $sbStopColor    widgetDefault

option add *Status.Action.borderWidth 2      widgetDefault
option add *Status.Action.height      7m     widgetDefault
option add *Status.Action.relief      sunken widgetDefault
option add *Status.Action.width       7m     widgetDefault

proc status_create {win} {
    frame $win -class Status

    set stop [option get $win stopColor  {}]

    frame $win.action -background $stop -class Action

    entry $win.message -justify left -state disabled

    set fill [option get $win spacing {}]

    pack $win.action \
	    -padx $fill -pady $fill -side left
    pack $win.message \
	    -expand yes -fill x -ipadx $fill \
	    -padx $fill -pady $fill -side left

    return [status_message $win "Initializing..."]
}

proc status_go {win {delay 0}} {
    global statusInfo

    if {[info exists statusInfo($win-afterId)]} {
	return $win
    }

    if {$delay < 1} {
	set delay [option get $win goMillisec {}]
	set delay [expr {($delay<20) ? 20 : $delay}]
    }

    set statusInfo($win-afterId) [after idle status_handle $win 0 $delay]

    return $win
}

proc status_handle {win step delay} {
    global statusInfo

    if {! [info exists statusInfo($win-afterId)]} {
	return $win
    }
    
    switch -exact -- $step {
	1       {set back [option get $win goColor1 {}]}
	default {set back [option get $win goColor0 {}]}
    }

    $win.action configure -background $back
    update

    set delay [expr {($delay<20) ? 20 : $delay}]
    set step [expr {($step+1) % 2}]
    set statusInfo($win-afterId) [after $delay status_handle $win $step $delay]

    return $win
}
proc status_message {win {message ""} {fore ""}} {
    if {$fore == ""} {
	set fore [option get $win foreground {}]
    }
    set whhat [string last "v1.0" $message]
    if {$whhat > -1} {
	# set message "You've got it"
    }
    $win.message configure -foreground $fore -state normal
    $win.message delete 0 end
    $win.message insert 0 $message
    $win.message configure -state disabled

    return $win
}

proc get_status_message {win} {

    return [$win.message get]

}

proc status_stop {win} {
    global statusInfo

    if {[info exists statusInfo($win-afterId)]} {
	after cancel statusInfo($win-afterId)
	unset statusInfo($win-afterId)
    }

    set back [option get $win stopColor {}]
    $win.action configure -background $back
    update

    return $win
}    

