# SimpleScalar Visualization Engine
# Simulation Stepping Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#
proc stepper_step {steps} {
    #
    # This is the main control routine during execution
    # controls how many steps we take
    # and what we display during those and after those steps
    #
    global StatisticsFor
    global ThumbsFor
    global bench_file
    # the current cycle number:
    set current [ss::getStatistic "sim_cycle"]
	# set current 1
     # if { ! [info exists current] } {
     # }
    # puts "current cycle number, requested cycles to step = $current, $steps"
    set stepType "one"
    if {! [catch {expr {int($steps+0.5)}} number]} {
	# puts "Stepping $number cycles"
	set finish [expr {$current+$number}]
	status_message .status "Stepping $number cycles"
	if {$number > 1} {
	    set stepType "oneChunk"
	} 
    } elseif {[string equal "infinity" $steps]} {
	status_message .status "Stepping to end of program.  Press the || button to pause."
	# note: 'current' not used in this invocation
	set number [stepfield_next .stepbar collect $current]
	set stepType "toEnd"
    } elseif {[string equal "step_few" $steps]} {
	# this condition may never be exercised(?)
	set number [stepfield_next .stepbar collect $current]
	status_message .status "Stepping $number cycles"
	set stepType "oneChunk"
    } else {
	status_message .status "Dear User: The step value must be a number."
	return 0
    }
    # puts "string? $steps; step type? $stepType"
    # We use the ::StopSign flag as a way to tell us when
    # to stop turning the crank
    catch {unset ::StopSign}

    status_go .status
    update idletasks
    update

    set allDone 0
    while {1} {
	# Re-set animation flags
	set updateGraphs    1
	set updateRUU_LSQ   1
	set updateStats     1
	set updateCycleCounter 1
	#
	# Step the simulator; i.e., turn the crank another time.
	set stepped [ss::step $number]
        if {$stepped < 1} {
	    # we've shot past the end of the benchmark
	    set allDone 1
	    # puts "All done!"
	}
        if {[info exists ::StopSign]} {
	    set pausePushed 1
        } else {
	    set pausePushed 0
	}
	if {[string equal $stepType "toEnd"]} {
	    if  {! $pausePushed}  {
		set updateRUU_LSQ   0
		set updateStats     0
	    }
	}
	if {[string equal $stepType "one"]} {
	    # don't cause a big statistical ruckus on the screen for
	    # a single step
	    set updateStats     0
	}
	# OK--now actually start updating the screen
	if {$updateCycleCounter} {
	    set current [expr {int([ss::getStatistic "sim_cycle"]+0.5)}]
	    .stepbar.cycles.value configure -text $current
	}
	stat_collect ::allStatistics ::allCycles
	set ipc_info [ss::getStatistic "sim_IPC"]
	if {$updateGraphs} {
	    display_graph_data
	}
        if {$updateRUU_LSQ} {
	    system_display .system
	}
	if {$updateStats} {
	    foreach label $StatisticsFor {
		display_statistics $label -1 -1 1
	    }
	}
	update idletasks
	update
	#
	if {[string equal "one" $stepType] || \
	   [string equal "oneChunk" $stepType] || \
	   $pausePushed || $allDone} {
	    set ipc_info [format "%.2f" $ipc_info]
	    if {[info exists ::StopSign]} {
		status_message .status \
		    "$bench_file: Simulation is paused.  \
		    Current IPC = $ipc_info.  \
		    Click on a unit for statistics."
		catch {unset ::StopSign}
	    } elseif {$stepped > 1} {
		status_message .status "$bench_file: Stepped ${stepped} cycles.  Current IPC = $ipc_info."
	    } elseif {$stepped > 0} {
		status_message .status "$bench_file: Stepped one cycle"
	    } else {
		status_message .status "$bench_file: Simulator finished; can step no more"
	    }
	    break
	}
    }
    set current [ss::getStatistic "sim_cycle"]
    status_stop .status
    update idletasks
    update
}

