# SimpleScalar Visualization Engine
# System Display
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

# source "$env(VISUAL_SOURCE_DIR)/unit.tcl"
source "ui/unit.tcl"

#-----------------------------------------------------------------------#
# System Settings
#
set WHeight  580
set WWidth   780
# global canvasBackgroundColor
global wholeApplicationBackground
global wholeApplicationFont
option add *background  $wholeApplicationBackground
option add *Font  $wholeApplicationFont

option add *System.Canvas.borderWidth 2         widgetDefault
option add *System.Canvas.height      $WHeight  widgetDefault
option add *System.Canvas.width       $WWidth   widgetDefault
option add *System.Canvas.padx        10        widgetDefault
option add *System.Canvas.pady        10        widgetDefault
option add *System.Canvas.relief      sunken    widgetDefault

option add *System.Canvas.boxFont {Helvetica 12 bold} widgetDefault
option add *System.Canvas.keyFont {Helvetica 10 bold} widgetDefault
option add *System.Canvas.numFont {Helvetica 8 bold}  widgetDefault

#-----------------------------------------------------------------------#
proc process_ruu_info {canvas wheight} {
    global unitInfo
    global Emptycolor 
    global Readycolor 
    global Issuedcolor 
    global Completedcolor 
    global Dispatchedcolor 
    global canvasSubColor
    global lastRUUInfo
    global filledRUUInfo
    global textHighlightColor 
    global currentTextFont
    global currentLeading
    global currentXoff

    set highlightColor $textHighlightColor
    set tfont $currentTextFont
    set leading $currentLeading
    set xOff $currentXoff
    # not used
    set ruuSize [ss::getOption "-ruu:size"]]

    # puts "height: $wheight; leading: $leading font: $tfont"

    # first erase all of what's in the current RUU

    foreach cellHoldingText [array names filledRUUInfo] {
	set ident $unitInfo(box:ruu/${cellHoldingText})
	$canvas itemconfigure $ident -fill $Emptycolor

        if {[info exists lastRUUInfo(OpText$ident)]} {
	    set optext $lastRUUInfo(OpText$ident)
	    set op2text $lastRUUInfo(Op2Text$ident)
	    # puts "Clear cell $cellHoldingText:$ident with opid=$optext, op2id=$op2text"
	    # fill with the empty or initial color
	    $canvas itemconfigure $optext -text ""
	    $canvas itemconfigure $op2text -text ""
	    unset optext
	    unset op2text
	}

	# now clean our memory of this RUU cell
	unset filledRUUInfo($cellHoldingText)
    }
    update idletasks
    update
    # OK--now time to get the current RUU cell states
    set ruuCellState [ss::getRUUItems 0] 
    # puts "RUU: $ruuCellState"
    set thisCellEndOfLine [string first ";" $ruuCellState]
    # the unitNum--the first cell value--is the head of the list
    set unitNum 0
    set ident 0
    while {$thisCellEndOfLine > 0} {
	# within this walk-through of the RUU items,

	set thisCellInfo [string range $ruuCellState \
		    0	$thisCellEndOfLine]

	# find the identity of the current RUU item
	set myStartIdIndex [string first "N:" $thisCellInfo]
	set myEndIdIndex [string first "=" $thisCellInfo]

	set myId [string range $thisCellInfo \
	    [expr $myStartIdIndex + 2] [expr $myEndIdIndex -1 ]]
        # puts "current cell: $thisCellInfo"
	# puts "got-->$myId."

	set ident $unitInfo(box:ruu/${myId})

	# find the opcode/operand string in the current cell

	set disInstructIndex [string first "D:" $thisCellInfo]
	set instruct [string range $thisCellInfo \
		[expr $disInstructIndex + 2] "end"]
	set instruct [string trim $instruct ";"]
	set space " "
	set opEndIndex [string first $space $instruct]
	set op [string range $instruct 0 [expr $opEndIndex - 1]]
	set Operands [string range $instruct $opEndIndex "end"]
	set Operands [string trim $Operands]
	# limit the length to avoid spillover
	# set Operands [string range $Operands 0 6]
	set Operands [string range $Operands 0 10]
	# got the opcode and the operand now
	if { [ info exists op ] } {
	    # now figure out the fill color
	    # shorten the string from the front
	    set ruuCellState [string range $ruuCellState \
			    [expr $thisCellEndOfLine + 1] "end"]
	    set thisCellEndOfLine [string first ";" $ruuCellState]
	    if {([string last "C:t" $thisCellInfo] > -1 )} {
		set ufiller $Completedcolor
	    } elseif {([string last "I:t" $thisCellInfo] > -1 )} {
		set ufiller $Issuedcolor
	    } elseif {([string last "Q:t" $thisCellInfo] > -1) } {
		set ufiller $Readycolor
	    } else {
		set ufiller $Dispatchedcolor
	    }
	}
	# So do the new fill color
	catch {$canvas itemconfigure $ident -fill $ufiller}

	if {1 > 0} {
	    set listCoords [$canvas coords $ident]
	    set myX [expr [lindex $listCoords 0] + $xOff]
	    set myY [expr [lindex $listCoords 1] + $leading ]

	    if {[array exists lastRUUInfo]} {
		if {[info exists lastRUUInfo(OpText${ident})]} {
		    set optext $lastRUUInfo(OpText${ident})
		    set op2text $lastRUUInfo(Op2Text${ident})
		}
	    }
	    if {$unitNum == 0} {
		set op [concat "H>> " $op]
	    } 
	    # At last, scribble on the new fill style
	    if {[info exists optext]} {
		# puts "configure existing cell $ident: $op $Operands"
		$canvas itemconfigure $optext \
		    -anchor nw -fill $highlightColor \
		    -font $tfont -text "$op"
		$canvas itemconfigure $op2text \
		    -anchor nw -fill $highlightColor \
		    -width 64 -font $tfont \
		    -text "$Operands" 
	    } else {
		set optext [$canvas create text $myX $myY -anchor nw -fill $highlightColor -font $tfont -text "$op"]

		set op2text [$canvas create text $myX [expr $myY + $leading ] -anchor nw -fill $highlightColor -width 64 -font $tfont -text "$Operands"]
		# puts "New opid=$optext; op2id=$op2text"
		# puts "New cell: $myId:$ident: $op $Operands; fill: $ufiller ($myX, $myY)"
		# To pop up the statistics window when the user presses
		# on the overlaid text...
		$canvas bind $optext <Button-1> [list unit_stat "ruu"]
		$canvas bind $op2text <Button-1> [list unit_stat "ruu"]
	    }
	    # save the current text and fill color information
	    set lastRUUInfo(Opc$ident) $op
	    set lastRUUInfo(Oper$ident) $Operands
	    set lastRUUInfo(Color$ident) $ufiller
	    set lastRUUInfo(OpText$ident) $optext
	    set lastRUUInfo(Op2Text$ident) $op2text
	    unset optext
	    unset op2text
	    # keep track of this cell number
            set filledRUUInfo($myId) $ident
	}
        # go on to the next cell, Maestro
	set unitNum [expr $unitNum + 1 ]
    }
    # let's have some fun:
    if {[info exists ident]} {
	if {[info exists lastRUUInfo(Opc$ident)] && ($unitNum > 1)} {
	    set tailOp $lastRUUInfo(Opc$ident) 
	    set tailOp [concat "T>> " $tailOp]
	    set tailOpIdent $lastRUUInfo(OpText$ident) 
	    $canvas itemconfigure $tailOpIdent \
		-anchor nw -fill $highlightColor \
		-font $tfont -text "$tailOp"

	    # puts "tail text: $tailOp"
	    # puts "tail id: $tailOpIdent"
	    # puts "======================="
	}
    }
}
proc system_create {window} {
    global unitList
    global unusedCellInfo
    global WWidth 
    global WHeight

    global canvasCoreColor 
    global canvasBoxColor
    global canvasMemoryColor
    global canvasSubColor
    global canvasBusColor 
    global canvasLabelColor 
    # NEW: for the unused cells
    global mainBackgroundColor

    frame $window -class System
    set canvas $window.canvas
    canvas $canvas
    pack $canvas -expand yes -fill both

    bind $canvas <Configure> [list system_redraw $canvas 1 ]
    set unitList [system_redraw $canvas 0]

    $canvas itemconfigure core     -fill $canvasCoreColor

    $canvas itemconfigure box:cbg  -fill $canvasBoxColor -stipple {}

    $canvas itemconfigure memory   -fill $canvasMemoryColor

    $canvas itemconfigure sub      -fill $canvasSubColor

    $canvas itemconfigure bus      -fill $canvasBusColor

    $canvas itemconfigure label    -fill $canvasLabelColor -stipple {}

    # $canvas itemconfigure unused   -fill $mainBackgroundColor
    foreach unusedName [array names unusedCellInfo] {
	set unusedItem $unusedCellInfo($unusedName)
	# puts "Coloring $unusedName == $unusedItem: $mainBackgroundColor"
	$canvas itemconfigure $unusedItem -fill $mainBackgroundColor
    }
    $canvas bind box   <Button-1> [list unit_show $canvas %x %y]
    $canvas bind bus   <Button-1> [list unit_show $canvas %x %y]
    $canvas bind label <Button-1> [list unit_show $canvas %x %y]

    # Bind the right mouse button to the popup menu.

    $canvas bind box   <Button-3> [list popup %W %x %y $canvas]
    $canvas bind bus   <Button-3> [list popup %W %x %y $canvas]
    $canvas bind label <Button-3> [list popup %W %x %y $canvas]
    set W [expr $WWidth + 40]
    set H [expr $WHeight + 60]
    wm maxsize . $W $H
    wm minsize . $W $H
    return $window
}

# If toggle is 1, the thumbnail for unit is displayed. If toggle is 0 and 
# unit is not NULL, the thumbnail for unit is deactivated. If toggle is 0
# and unit is NULL, no thumbnail is displayed. Only three thumbnails, for
# the I-Cache, D-Cache and the Branch Predictor have been implemented till
# now.

proc system_redraw {canvas forceful} {

    global Emptycolor 
    global Readycolor 
    global Issuedcolor 
    global Completedcolor 
    global Dispatchedcolor 
    global FUInfo

    # "forceful" is "1" if this is a window resize event, "0" otherwise

    if {$forceful} {
	delete_ifq_text $canvas 
	delete_ruu_text $canvas 
	delete_lsq_text $canvas
        # delete_unused_cells $canvas
    }
    set padx [option get $canvas padx {}]
    set pady [option get $canvas pady {}]

    set xmin [expr {$padx+1}]
    set ymin [expr {$pady+1}]

    set xmax [expr [winfo width  $canvas]-$padx-1]
    set ymax [expr [winfo height $canvas]-$pady-1]

    set high [expr {$ymax-$ymin}]
    set wide [expr {$xmax-$xmin}]

    set busLong [expr {(4.0*$high+3.0*$wide)/120.0}]
    set busWide [expr {0.5*$busLong}]

    set font [option get $canvas boxFont {}]
    set kfont [option get $canvas keyFont {}]

    lappend unitlist \
	[unit_box $canvas $font "" cbg {background core} \
	    $xmin \
	    $ymin \
	    $xmax \
	    [expr {$ymax-6.0*$busLong+$pady}] 0]

    set coreXmin [expr {$xmin+$padx}]
    set coreYmin [expr {$ymin+$pady}]

    set coreXmax [expr {$xmax-$padx}]
    set coreYmax [expr {$ymax-6.0*$busLong}]

    set coreHigh [expr {$coreYmax-$coreYmin}]
    set coreWide [expr {$coreXmax-$coreXmin}]

    set execWide [expr {0.75*($coreWide-$busLong)}]
    set ftchWide [expr {$coreWide-$busLong-$execWide}]

    set halfHigh [expr {0.5*($coreHigh-$busLong)}]

    set brnWide [expr {0.25*($ftchWide-$busWide)}]
    set ifqWide [expr {$ftchWide-$busWide-$brnWide}]
    set lsqWide [expr {0.5*($execWide-$busLong)}]

    set keyWide [expr {0.75 * $lsqWide}]

    set ruuHigh [expr {0.5*($coreHigh-$busLong)}]

    # Bus Pair:  BPB <-> IFQ
    #

    lappend unitlist \
	    [unit_bus $canvas bpb ifq {branch core internal fetch} \
	    [expr {$coreXmin+$brnWide}] \
	    [expr {$coreYmin+0.70*$halfHigh}] \
	    [expr {$coreXmin+$brnWide+$busWide}] \
	    [expr {$coreYmin+0.70*$halfHigh}]]

    lappend unitlist \
	[unit_bus $canvas ifq bpb {branch core internal fetch} \
	    [expr {$coreXmin+$brnWide+$busWide}] \
	    [expr {$coreYmin+0.30*$halfHigh}] \
	    [expr {$coreXmin+$brnWide}] \
	    [expr {$coreYmin+0.30*$halfHigh}]]

    # Bus Pair:  BTB <-> IFQ
    #
    lappend unitlist \
	[unit_bus $canvas btb ifq {branch core internal fetch} \
	    [expr {$coreXmin+$brnWide}] \
	    [expr {$coreYmax-0.30*$halfHigh}] \
	    [expr {$coreXmin+$brnWide+$busWide}] \
	    [expr {$coreYmax-0.30*$halfHigh}]]

    lappend unitlist \
	[unit_bus $canvas ifq btb {branch core internal fetch} \
	    [expr {$coreXmin+$brnWide+$busWide}] \
	    [expr {$coreYmax-0.70*$halfHigh}] \
	    [expr {$coreXmin+$brnWide}] \
	    [expr {$coreYmax-0.70*$halfHigh}]]

    # Bus Singleton:  IFQ -> RUU
    #
    lappend unitlist \
        [unit_bus $canvas ifq ruu {core dispatch internal} \
	    [expr {$coreXmin+$brnWide+$busWide+$ifqWide}] \
	    [expr {$coreYmin+0.50*$halfHigh}] \
	    [expr {$coreXmax-$execWide}] \
	    [expr {$coreYmin+0.50*$halfHigh}]]

    # Bus Singleton:  RUU -> FNU
    #
    lappend unitlist \
	[unit_bus $canvas ruu fnu {core function internal} \
	    [expr {$coreXmax-0.5*$lsqWide}] \
	    [expr {$coreYmax-$ruuHigh-$busLong}] \
	    [expr {$coreXmax-0.5*$lsqWide}] \
	    [expr {$coreYmax-$ruuHigh}]]

    # Bus Pair:  FUs <-> LSQ
    #
    lappend unitlist \
	[unit_bus $canvas fnu lsq {core function internal} \
	    [expr {$coreXmax-$lsqWide}] \
	    [expr {$coreYmax-0.70*$ruuHigh}] \
	    [expr {$coreXmax-$lsqWide-$busLong}] \
	    [expr {$coreYmax-0.70*$ruuHigh}]]

    lappend unitlist \
	[unit_bus $canvas lsq fnu {core function internal} \
	    [expr {$coreXmax-$lsqWide-$busLong}] \
	    [expr {$coreYmax-0.30*$ruuHigh-10}] \
	    [expr {$coreXmax-$lsqWide}] \
	    [expr {$coreYmax-0.30*$ruuHigh-10}]]

    # Bus Pair:  DL1C <-> LSQ
    #
    set busXOffset -21
    set downMemoryBusX [expr {$coreXmax-$execWide+0.70*$lsqWide}] 
    set upMemoryBusX [expr {$coreXmax-$execWide+0.70*$lsqWide}] 
    set downMemoryBusRightX [expr {$coreXmax-$execWide+0.30*$lsqWide}] \

    lappend unitlist \
	[unit_bus $canvas lsq d1c {cache data internal} \
	    [expr {$upMemoryBusX + $busXOffset }] \
	    $coreYmax \
	    [expr {$upMemoryBusX + $busXOffset }] \
	    [expr {$ymax-5.0*$busLong}]]

    lappend unitlist \
	[unit_bus $canvas d1c lsq {cache data internal} \
	    [expr {$downMemoryBusRightX + $busXOffset }] \
	    [expr {$ymax-5.0*$busLong}] \
	    [expr {$downMemoryBusRightX + $busXOffset }] \
	    $coreYmax]

    # Bus Pair:  L2C <-> D1C
    #
    set busXOffset 30
    lappend unitlist \
	[unit_bus $canvas d1c l2c {cache data internal} \
	    [expr {$downMemoryBusX + $busXOffset }] \
	    [expr {$ymax-4.0*$busLong}] \
	    [expr {$downMemoryBusX + $busXOffset }] \
	    [expr {$ymax-3.0*$busLong}]]
    # old X
    # [expr {$coreXmax-$execWide+0.80*$lsqWide}] \
    #
    lappend unitlist \
	[unit_bus $canvas l2c d1c {cache data internal} \
	    [expr {$upMemoryBusX - (2 * $busXOffset) }] \
	    [expr {$ymax-3.0*$busLong}] \
	    [expr {$upMemoryBusX - (2 * $busXOffset) }] \
	    [expr {$ymax-4.0*$busLong}]]

    # Bus Singleton:  I1C -> IFQ
    #
    set busXOffset 0
    set upMemoryBusX [expr {$coreXmin+$brnWide+$busWide+0.5*$ifqWide}] 
    #
    # old X values:
    # [expr {$coreXmin+$brnWide+$ifqWide}] \

    lappend unitlist \
	[unit_bus $canvas i1c ifq {cache fetch instruction} \
	    [expr $upMemoryBusX - $busXOffset ] \
	    [expr {$ymax-5.0*$busLong}] \
	    [expr $upMemoryBusX - $busXOffset ] \
	    $coreYmax]

    # Bus Singleton:  L2C -> I1C
    #
    set busXOffset 30
    lappend unitlist \
	[unit_bus $canvas l2c i1c {cache fetch instruction} \
	    [expr $upMemoryBusX - $busXOffset ] \
	    [expr {$ymax-3.0*$busLong}] \
	    [expr $upMemoryBusX - $busXOffset ] \
	    [expr {$ymax-4.0*$busLong}]]

    # Bus Pair:  MEM <-> L2C
    #
    set busXOffset 60
    #
    lappend unitlist \
	[unit_bus $canvas l2c mem {cache data external instruction memory} \
	    [expr $upMemoryBusX - $busXOffset ] \
	    [expr {$ymax-1.0*$busLong}] \
	    [expr $upMemoryBusX - $busXOffset ] \
	    [expr {$ymax-2.0*$busLong}]]

    lappend unitlist \
	[unit_bus $canvas mem l2c {cache data external instruction memory} \
	    [expr {$downMemoryBusX + $busXOffset }] \
	    [expr {$ymax-2.0*$busLong}] \
	    [expr {$downMemoryBusX + $busXOffset }] \
	    [expr {$ymax-1.0*$busLong}]]

    # Place core units:
    #
    lappend unitlist \
	    [unit_box $canvas $font "BPB" bpb \
	    {branch core fetch internal} \
	    $coreXmin \
	    $coreYmin \
	    [expr {$coreXmin+$brnWide}] \
	    [expr {$coreYmin+$halfHigh}] 1]
    
    lappend unitlist \
	[unit_box $canvas $font "BTB" btb {branch core fetch internal} \
	    $coreXmin \
	    [expr {$coreYmax-$halfHigh}] \
	    [expr {$coreXmin+$brnWide}] \
	    $coreYmax 0]

    lappend unitlist \
	[unit_box $canvas $font "IFQ" ifq {core fetch internal queue} \
	    [expr {$coreXmin+$brnWide+$busWide}] \
	    $coreYmin \
	    [expr {$coreXmin+$brnWide+$busWide+$ifqWide}] \
	    $coreYmax 0]

    eval lappend unitlist \
	[unit_grid $canvas ifq [ss::getOption "-fetch:ifqsize"]]

    lappend unitlist \
	[unit_box $canvas $font "RUU" ruu {core execute internal queue} \
	    [expr {$coreXmax-$execWide}] \
	    $coreYmin \
	    $coreXmax \
	    [expr {$coreYmin+$ruuHigh}] 0]

    eval lappend unitlist \
	[unit_grid $canvas ruu [ss::getOption "-ruu:size"]]

    lappend unitlist \
	[unit_box $canvas $font "FUs" fnu {core execute internal} \
	    [expr {$coreXmax-$lsqWide}] \
	    [expr {$coreYmax-$ruuHigh}] \
	    $coreXmax \
	    $coreYmax 0]

    eval lappend unitlist [unit_fnu $canvas fnu]

    lappend unitlist \
	[unit_box $canvas $font "LSQ" lsq {core execute internal queue} \
	    [expr {$coreXmax-$execWide}] \
	    [expr {$coreYmax-$ruuHigh}] \
	    [expr {$coreXmax-$lsqWide-$busLong}] \
	    $coreYmax 0]

    eval lappend unitlist \
	[unit_grid $canvas lsq [ss::getOption "-lsq:size"]]

    #-------------------#
    # Memory Hierarchy: #
    #-------------------#

    # Unit MEM:  Main Memory
    #
    lappend unitlist \
	[unit_box $canvas $font "Memory" mem {external memory} \
	    $xmin \
	    [expr {$ymax-$busLong}] \
	    $xmax \
	    $ymax 0]

    # Unit L2C:  Level 2 Cache
    #
    lappend unitlist \
	[unit_box $canvas $font "L2 Cache" l2c {cache level2 memory} \
	    $xmin \
	    [expr {$ymax-3.0*$busLong}] \
	    [expr {0.5*($xmax+$coreXmax-$lsqWide-$busLong)}] \
	    [expr {$ymax-2.0*$busLong}] 0]

    # Unit I1C:  Level 1 Instruction Cache
    #

    lappend unitlist \
	    [unit_box $canvas $font "IL1 Cache" i1c \
	    {cache instruction level1 memory} \
	    [expr {$coreXmin+$brnWide+$busWide}] \
	    [expr {$ymax-5.0*$busLong}] \
	    [expr {$coreXmax-$execWide-$busWide}] \
	    [expr {$ymax-4.0*$busLong}] 1]

    # Unit D1C:  Level 1 Data Cache
    #
    lappend unitlist \
	    [unit_box $canvas $font "DL1 Cache" d1c \
	    {cache data level1 memory} \
	    [expr {$coreXmax-$execWide-$busWide + 12}] \
	    [expr {$ymax-5.0*$busLong}] \
	    [expr {$coreXmax-$lsqWide-$busLong}] \
	    [expr {$ymax-4.0*$busLong}] 1]
    
    # Unit ITLB:  Instruction-path Translation Lookaside Buffer
    #
    lappend unitlist \
	[unit_box $canvas $font "ITLB" itlb \
	    {instruction internal memory tlb} \
	    $xmin \
	    [expr {$ymax-5.0*$busLong}] \
	    [expr {$coreXmin+$brnWide+$busWide-$padx}] \
	    [expr {$ymax-4.0*$busLong}] 0]

    # Unit DTLB:  Data-path Translation Lookaside Buffer
    #
    set dtlbxlo [expr {$coreXmax-$lsqWide-$busLong+$padx}] 
    set dtlbylo [expr {$ymax-5.0*$busLong}] 
    set dtlbxhi [expr {0.5*($xmax+$coreXmax-$lsqWide-$busLong)}] 
    set dtlbyhi [expr {$ymax-4.0*$busLong}]

    lappend unitlist \
	[unit_box $canvas $font "DTLB" dtlb {data internal memory tlb} \
		$dtlbxlo \
		$dtlbylo \
		$dtlbxhi \
		$dtlbyhi \
		0 ]

    # now for displaying the color keys
	set x1lo [expr {$dtlbxhi + $busWide}]
	set y1lo $dtlbylo
	set x1hi [expr {$x1lo + ($busLong * 2.5)}]
	set y1hi [expr {$y1lo + ($busWide * 1)}]

    lappend unitlist \
	[unit_key $canvas $kfont "Empty" empty {nocolor} \
	    $x1lo $y1lo $x1hi $y1hi $Emptycolor ]

	set x2lo [expr {$dtlbxhi + $busWide}]
	set y2lo [expr {$y1hi + ($busWide * 0.5)}]
	set x2hi [expr {$x1lo + ($busLong * 2.5)}]
	set y2hi [expr {$y2lo + ($busWide * 1)}]

    lappend unitlist \
	[unit_key $canvas $kfont "Dispatched" busy {nocolor} \
	    $x2lo $y2lo $x2hi $y2hi $Dispatchedcolor ]

	set x3lo [expr {$dtlbxhi + $busWide}]
	set y3lo [expr {$y2hi + ($busWide * 0.5)}]
	set x3hi [expr {$x1lo + ($busLong * 2.5)}]
	set y3hi [expr {$y3lo + ($busWide * 1)}]

    lappend unitlist \
	[unit_key $canvas $kfont "Ready" ready {nocolor} \
	    $x3lo $y3lo $x3hi $y3hi $Readycolor ]

	set x4lo [expr {$dtlbxhi + $busWide}]
	set y4lo [expr {$y3hi + ($busWide * 0.5)}]
	set x4hi [expr {$x1lo + ($busLong * 2.5)}]
	set y4hi [expr {$y4lo + ($busWide * 1)}]

    lappend unitlist \
	[unit_key $canvas $kfont "Issued" issued {nocolor} \
	    $x4lo $y4lo $x4hi $y4hi $Issuedcolor ]

	set x5lo [expr {$dtlbxhi + $busWide}]
	set y5lo [expr {$y4hi + ($busWide * 0.5)}]
	set x5hi [expr {$x1lo + ($busLong * 2.5)}]
	set y5hi [expr {$y5lo + ($busWide * 1)}]

    lappend unitlist \
	[unit_key $canvas $kfont "Commit" completed {nocolor} \
	    $x5lo $y5lo $x5hi $y5hi $Completedcolor ]

    initialize_fu_info 

    return $unitlist
}
proc delete_ruu_text {canvas} {
    global filledRUUInfo
    global unitInfo
    global lastRUUInfo
    # puts "Delete the RUU text"
    foreach cellHoldingText [array names filledRUUInfo] {
	set ident $unitInfo(box:ruu/${cellHoldingText})

	set optext $lastRUUInfo(OpText$ident)
	set op2text $lastRUUInfo(Op2Text$ident)
	# should we also color the cell with the empty color?
	# puts "Clear cell $cellHoldingText:$ident with opid=$optext, op2id=$op2text"
	$canvas delete $optext $op2text

	# now clean our memory of this RUU cell
	# unset filledLSQInfo($cellHoldingText)
	# unset optext
	# unset op2text
    }
}
proc delete_lsq_text {canvas} {
    global filledLSQInfo
    global unitInfo
    global lastLSQInfo
    # puts "Delete the LSQ text"
    foreach cellHoldingText [array names filledLSQInfo] {
	set ident $unitInfo(box:lsq/${cellHoldingText})

	set optext $lastLSQInfo(OpText$ident)
	set op2text $lastLSQInfo(Op2Text$ident)
	# should we also color the cell with the empty color?
	# puts "Clear cell $cellHoldingText:$ident with opid=$optext, op2id=$op2text"
	$canvas delete $optext $op2text

	# now clean our memory of this LSQ cell
	# unset filledLSQInfo($cellHoldingText)
	# unset optext
	# unset op2text
    }
}
proc delete_ifq_text {canvas} {
    global lastIFQInfo
    if {[info exists lastIFQInfo]} {
	foreach ifqName [array names lastIFQInfo] {
            set ifqItem $lastIFQInfo($ifqName)
	    $canvas delete $ifqItem 
	    # force a re-create of the text widget next time
	    # puts "Unsetting $ifqName == $ifqItem"
	    unset lastIFQInfo($ifqName)
	}
    }
}
proc delete_unused_cells {canvas} {
    global unusedCellInfo
    foreach unusedName [array names unusedCellInfo] {
	set unusedItem $unusedCellInfo($unusedName)
	# puts "Deleting $unusedName == $unusedItem"
	$canvas delete $unusedItem 
	# remove all vestiges
	unset unusedCellInfo($unusedName)
    }
}

global FUInfo

proc initialize_fu_info {} {
    # Actually, all the initialization occurs as a by-product
    # of the sub() subroutine in unit_fnu(), which is called in the
    # system_redraw() routine from this module and which sets
    # up the global FUInfo array.
    #
    # set fuCellState [ss::getFUItems 0 ] 
}
proc process_fu_info {canvas wheight} {
    global FUInfo
    global unitInfo

    global Emptycolor 
    global Readycolor 
    global Issuedcolor 
    global Completedcolor 
    global Dispatchedcolor 
    global FUBusycolor 
    global textHighlightColor 
    global currentTextFont
    global currentLeading
    global currentXoff

    set highlightColor $textHighlightColor
    set tfont $currentTextFont
    set leading $currentLeading
    set xOff $currentXoff
    # puts "height: $wheight; leading: $leading font: $tfont"

    set fuCellState [ss::getFUItems 0] 
    # puts "----------------"
    # puts "$fuCellState"
    set thisCellEndOfLine [string first ";" $fuCellState]
    set space " "
    while {$thisCellEndOfLine > 0} {
	# within this walk-through of the FU items,

	set thisCellInfo [string range $fuCellState \
		    0	$thisCellEndOfLine]

	# find the identity of the current FU item
	set myStartIndex [string first "I:" $thisCellInfo]
	set myEndIndex [string first $space $thisCellInfo]
	set myId [string range $thisCellInfo \
	    [expr $myStartIndex + 2] [expr $myEndIndex -1 ]]

	set restOfCell [string range $thisCellInfo [expr $myEndIndex + 1] "end"]
	set myStartIndex [string first "N:" $restOfCell]
	set myEndIndex [string first $space $restOfCell]

	set myFUName [string range $restOfCell \
	    [expr $myStartIndex + 2] [expr $myEndIndex -1 ]]
	if {! [string equal "memory-port" $myFUName]} {
	    # puts "current cell: $thisCellInfo"
	    # puts "got FUN-->$myFUName."
	}
	if {([string last "B:0" $restOfCell] > -1 )} {
	    # not busy
	    set ufiller $Emptycolor
	} else {
	    set ufiller $FUBusycolor
	}
        switch $myFUName {
	    "integer-ALU" {
		set label "I+I"
	    }
	    "integer-MULT/DIV" {
		set label "IxI"
	    }
	    "FP-adder" {
		set label "F+F"
	    }
	    "FP-MULT/DIV" {
		set label "FxF"
	    }
	    default {
		set label "memory-port"
		# puts "don't get it: $myFUName."
	    }
	}
	if {[string compare $label "memory-port"]} {
	    set ident $FUInfo(${myId},${label})
	    # USEFUL and important debugging statement:
	    # puts "FUInfo($myId:$label)=$ident-->$ufiller"
	    # So do the new fill color
	    catch {$canvas itemconfigure $ident -fill $ufiller}
	} 
        # go on to the next cell, Maestro
	set fuCellState [string range $fuCellState \
		    [expr $thisCellEndOfLine + 1] "end"]
	set thisCellEndOfLine [string first ";" $fuCellState]
    }
    # puts "======================="
}
proc process_lsq_info {canvas wheight} {
    global Emptycolor 
    global Readycolor 
    global Issuedcolor 
    global Completedcolor 
    global unitInfo
    global Dispatchedcolor

    global lastLSQInfo
    global filledLSQInfo
    global textHighlightColor 
    global currentTextFont
    global currentLeading
    global currentXoff

    set highlightColor $textHighlightColor
    set tfont $currentTextFont
    set leading $currentLeading
    set xOff $currentXoff

    # puts "height: $wheight; leading: $leading font: $tfont"

    # first erase what's there

    # puts "Clear the LSQ of old stuff:"
    foreach cellHoldingText [array names filledLSQInfo] {
	set ident $unitInfo(box:lsq/${cellHoldingText})

	set optext $lastLSQInfo(OpText$ident)
	set op2text $lastLSQInfo(Op2Text$ident)
	# puts "Clear cell $cellHoldingText:$ident with opid=$optext, op2id=$op2text"
        # fill with the empty or initial color
	$canvas itemconfigure $ident -fill $Emptycolor
	$canvas itemconfigure $optext -text ""
	$canvas itemconfigure $op2text -text ""

	# now clean our memory of this LSQ cell
	unset filledLSQInfo($cellHoldingText)
	unset optext
	unset op2text
    }
    update idletasks
    update
    # OK--now time to get the current LSQ cell state
    set lsqCellState [ss::getLSQItems 0] 
    # puts "----------------"
    # puts "lsq: $lsqCellState"
    set thisCellEndOfLine [string first ";" $lsqCellState]
    set unitNum 0
    while {$thisCellEndOfLine > 0} {
	# within this walk-through of the LSQ items,

	set thisCellInfo [string range $lsqCellState \
		    0	$thisCellEndOfLine]

	# find the identity of the current LSQ item
	set myStartIdIndex [string first "N:" $thisCellInfo]
	set myEndIdIndex [string first "=" $thisCellInfo]

	set myId [string range $thisCellInfo \
	    [expr $myStartIdIndex + 2] [expr $myEndIdIndex -1 ]]
        # puts "current cell: $thisCellInfo"
	# puts "got-->$myId."

	set ident $unitInfo(box:lsq/${myId})

	# find the opcode/operand string in the current cell
	set disInstructIndex [string first "D:" $thisCellInfo]
	set instruct [string range $thisCellInfo \
		[expr $disInstructIndex + 2] "end"]
	set instruct [string trim $instruct ";"]
	set space " "
	set opEndIndex [string first $space $instruct]
	set op [string range $instruct 0 [expr $opEndIndex - 1]]
	if {$unitNum == 0} {
	    # puts "this baby ($myId:$op) is the head---"
	    set op [concat "H>> " $op]
	}
	set Operands [string range $instruct $opEndIndex "end"]
	set Operands [string trim $Operands]
	# limit the length to avoid spillover
	set Operands [string range $Operands 0 6]
	# got the opcode and the operand now
	if { [ info exists op ] } {
	    # now figure out the fill color
	    # shorten the string from the front
	    set lsqCellState [string range $lsqCellState \
			    [expr $thisCellEndOfLine + 1] "end"]
	    set thisCellEndOfLine [string first ";" $lsqCellState]
	    if {([string last "C:t" $thisCellInfo] > -1 )} {
		set ufiller $Completedcolor
	    } elseif {([string last "I:t" $thisCellInfo] > -1 )} {
		set ufiller $Issuedcolor
	    } elseif {([string last "Q:t" $thisCellInfo] > -1) } {
		set ufiller $Readycolor
	    } else {
		# set ufiller $Emptycolor
		set ufiller $Dispatchedcolor
	    }
	}
	# So do the new fill color
	catch {$canvas itemconfigure $ident -fill $ufiller}

	if {1 > 0} {
	    set listCoords [$canvas coords $ident]
	    set myX [expr [lindex $listCoords 0] + $xOff]
	    set myY [expr [lindex $listCoords 1] + $leading ]

	    if {[array exists lastLSQInfo]} {
		if {[info exists lastLSQInfo(OpText${ident})]} {
		    set optext $lastLSQInfo(OpText${ident})
		    set op2text $lastLSQInfo(Op2Text${ident})
		}
	    }
	    # At last, scribble on the new fill style
	    if {[info exists optext]} {
		# puts "configure existing cell $ident: $op $Operands"
		$canvas itemconfigure $optext \
		    -anchor nw -fill $highlightColor \
		    -font $tfont -text "$op"
		$canvas itemconfigure $op2text \
		    -anchor nw -fill $highlightColor \
		    -width 60 -font $tfont \
		    -text "$Operands" 
	    } else {
		set optext [$canvas create text $myX $myY -anchor nw -fill $highlightColor -font $tfont -text "$op"]

		set op2text [$canvas create text $myX [expr $myY + $leading ] -anchor nw -fill $highlightColor -width 60 -font $tfont -text "$Operands"]
		# puts "New opid=$optext; op2id=$op2text"
		# puts "New cell: $myId:$ident: $op $Operands; fill: $ufiller ($myX, $myY)"
		# To pop up the statistics window when the user presses
		# on the overlaid text...
		$canvas bind $optext <Button-1> [list unit_stat "lsq"]
		$canvas bind $op2text <Button-1> [list unit_stat "lsq"]
	    }

	    # save the current text and fill color information
	    set lastLSQInfo(Opc$ident) $op
	    set lastLSQInfo(Oper$ident) $Operands
	    set lastLSQInfo(Color$ident) $ufiller
	    set lastLSQInfo(OpText$ident) $optext
	    set lastLSQInfo(Op2Text$ident) $op2text
	    unset optext
	    unset op2text
	    # keep track of this cell number
	    # puts "marking $myId:$ident as used"
            set filledLSQInfo($myId) $ident
	}
        # go on to the next cell, Maestro
	set unitNum [expr $unitNum + 1 ]
    }
    # let's have some fun:
    if {[info exists ident]} {
	if {[info exists lastLSQInfo(Opc$ident)] && ($unitNum > 1)} {
	    set tailOp $lastLSQInfo(Opc$ident) 
	    set tailOp [concat "T>> " $tailOp]
	    set tailOpIdent $lastLSQInfo(OpText$ident) 
	    $canvas itemconfigure $tailOpIdent \
		-anchor nw -fill $highlightColor \
		-font $tfont -text "$tailOp"

	    # puts "tail text: $tailOp"
	    # puts "tail id: $tailOpIdent"
	    # puts "======================="
	}
    }
    # puts "======================="
}
proc process_ifq_info {canvas wheight} {
    global unitInfo
    global Emptycolor 
    global Readycolor 
    global Issuedcolor 
    global Completedcolor 
    global canvasSubColor
    global lastIFQInfo
    global filledIFQInfo
    global textHighlightColor 
    global currentTextFont
    global currentLeading
    global currentXoff

    set highlightColor $textHighlightColor
    set tfont $currentTextFont
    set leading $currentLeading
    set xOff $currentXoff

    # puts "height: $wheight; leading: $leading font: $tfont"

    # first erase all of what's in the current IFQ

    foreach cellHoldingText [array names filledIFQInfo] {
	set ident $unitInfo(box:ifq/${cellHoldingText})
	$canvas itemconfigure $ident -fill $Emptycolor

        if {[info exists lastIFQInfo(OpText$ident)]} {
	    set optext $lastIFQInfo(OpText$ident)
	    set op2text $lastIFQInfo(Op2Text$ident)
	    set pctext $lastIFQInfo(PcText$ident)
	    # puts "Clear cell $cellHoldingText:$ident with opid=$optext, op2id=$op2text,pc=$pctext"
	    # fill with the empty or initial color
	    $canvas itemconfigure $optext -text ""
	    $canvas itemconfigure $op2text -text ""
	    $canvas itemconfigure $pctext -text ""
	    unset pctext
	    unset optext
	    unset op2text
	}
	# now clean our memory of this IFQ cell
	unset filledIFQInfo($cellHoldingText)
    }
    update idletasks
    update
    # OK--now time to get the current IFQ cell states
    set ifqCellState [ss::getIFQItems] 
    # puts "Total Cells: $ifqCellState"
    set thisCellEndOfLine [string first ";" $ifqCellState]

    set ident 0
    while {$thisCellEndOfLine > 0} {
	# within this walk-through of the IFQ items,

	set thisCellInfo [string range $ifqCellState \
		    0	$thisCellEndOfLine]

        # puts "current cell: $thisCellInfo"
	# find the identity of the current IFQ item
	set myStartIdIndex [string first "N=" $thisCellInfo]
	set myEndIdIndex [string first "H:" $thisCellInfo]
	set myId [string range $thisCellInfo \
	    [expr $myStartIdIndex + 2] [expr $myEndIdIndex - 1 ]]
	set myId [string trim $myId]
	# puts "got-->$myId."

	set ident $unitInfo(box:ifq/${myId})
	# puts "ident for this IFQ is $ident."

	set space " "
	if {([string last "H:0" $thisCellInfo] > -1 )} {
	    set H 0
	} elseif {([string last "H:1" $thisCellInfo] > -1 )} {
	    set H 1
	} elseif {([string last "H:2" $thisCellInfo] > -1 )} {
	    set H 2
	} else {
	    set H 3
	}
	# find the opcode/operand string in the current cell
	set pcCounterStartIndex [string first "P:" $thisCellInfo]
	set pcCounterEndIndex [expr [string first "I:" $thisCellInfo] -2]
	set pcCounter [string range $thisCellInfo \
		[expr $pcCounterStartIndex + 2] $pcCounterEndIndex]

        # puts "Counter: $pcCounter"
	set opStartIndex [string first "I:" $thisCellInfo]
	set opEndIndex [string last ";" $thisCellInfo]
	set opEndIndex [expr $opEndIndex - 1 ]

	set fullOp [string range $thisCellInfo [expr $opStartIndex +2]\
		$opEndIndex ]

	set OpcodeEndIndex [string first $space $fullOp]
	# puts "fullOp=$fullOp. OpcodeEndIndex=$OpcodeEndIndex"
	set Opcode [string range $fullOp 0 [expr $OpcodeEndIndex - 1]]
        set OpcodeLength [string length $Opcode]
	set Operands [string range $fullOp $OpcodeLength "end"]
	set Operands [string trim $Operands]

	# limit the length to avoid IFQ cell spillover
	# set Operands [string range $Operands 0 9]
	set Operands [string range $Operands 0 10]
	switch $H {
	    "0" {
		set Opcode "HT>>${Opcode}"
	    }
	    "1" {
		set Opcode "H>>${Opcode}"
	    }
	    "3" {
		set Opcode "T>>${Opcode}"
	    }
	}
	# puts "Opcode=$Opcode; Operands=$Operands"

	# shorten the string from the front
	set ifqCellState [string range $ifqCellState \
			[expr $thisCellEndOfLine + 1] "end"]
	set thisCellEndOfLine [string first ";" $ifqCellState]

	# So do the new fill color
	set ufiller $Emptycolor
	# catch {$canvas itemconfigure $ident -fill $ufiller}

	if {1 > 0} {
	    set listCoords [$canvas coords $ident]
	    set myX [expr [lindex $listCoords 0] + $xOff]
	    set myY [expr [lindex $listCoords 1] + $leading ]

	    if {[array exists lastIFQInfo]} {
		if {[info exists lastIFQInfo(OpText${ident})]} {
		    set optext $lastIFQInfo(OpText${ident})
		    set op2text $lastIFQInfo(Op2Text${ident})
		    set pctext $lastIFQInfo(PcText${ident})
		}
	    }
	    # At last, scribble on the new fill style
	    if {[info exists optext]} {
		# puts "configure existing cell #$myId with ident $ident: $Opcode $Operands $pcCounter"
		$canvas itemconfigure $optext \
		    -anchor nw -fill $highlightColor \
		    -font $tfont -text "$Opcode"
		$canvas itemconfigure $op2text \
		    -anchor nw -fill $highlightColor \
		    -width 64 -font $tfont \
		    -text "$Operands" 
		$canvas itemconfigure $pctext \
		    -anchor nw -fill $highlightColor \
		    -width 64 -font $tfont \
		    -text "$pcCounter" 
	    } else {
		set optext [$canvas create text $myX $myY -anchor nw -fill $highlightColor -font $tfont -text "$Opcode"]

		set op2text [$canvas create text $myX [expr $myY + $leading ] -anchor nw -fill $highlightColor -width 64 -font $tfont -text "$Operands"]
		set pctext [$canvas create text $myX \
			[expr $myY + ($leading *2) ] -anchor nw \
			-fill $highlightColor -width 64 \
			-font $tfont -text "$pcCounter"]
		# puts "New opid=$optext; op2id=$op2text; pcid=$pctext"
		# puts "New cell: $myId:$ident: $Opcode $Operands $pcCounter;  fill: $ufiller ($myX, $myY)"
		# To pop up the statistics window when the user presses
		# on the overlaid text...
		$canvas bind $optext <Button-1> [list unit_stat "ifq"]
		$canvas bind $op2text <Button-1> [list unit_stat "ifq"]
		$canvas bind $pctext <Button-1> [list unit_stat "ifq"]
	    }
	    # save the current text and fill color information
	    set lastIFQInfo(Opc$ident) $Opcode
	    set lastIFQInfo(Oper$ident) $Operands
	    set lastIFQInfo(Color$ident) $ufiller
	    set lastIFQInfo(OpText$ident) $optext
	    set lastIFQInfo(Op2Text$ident) $op2text
	    set lastIFQInfo(PcText$ident) $pctext
	    unset optext
	    unset op2text
	    unset pctext
	    # keep track of this cell number
            set filledIFQInfo($myId) $ident
	}
    }
}
proc old_process_ifq_info {canvas wheight} {
    global lastIFQInfo

    set ifqCellState [ss::getIFQItems] 
    # puts "IFQ: $ifqCellState"

    # First, clean off the current IFQ unit
    if {[info exists lastIFQInfo]} {
	foreach ifqName [array names lastIFQInfo] {
            set ifqItem $lastIFQInfo($ifqName)
	    # puts "$ifqName == $ifqItem"
	    # Zero out the text widget
	    $canvas itemconfigure $ifqItem -anchor nw -text ""
	}
    }
}
proc system_display {window} {
    global unitInfo
    global unitList

    global BIG_TEXT_FONT 
    global MEDIUM_TEXT_FONT 
    global SMALL_TEXT_FONT 
    global TINY_TEXT_FONT 

    global BIG_LEADING
    global MEDIUM_LEADING
    global SMALL_LEADING
    global TINY_LEADING

    global BIG_XOFF
    global MEDIUM_XOFF
    global SMALL_XOFF
    global TINY_XOFF

    global currentTextFont
    global currentLeading
    global currentXoff

    # repaint the whole app window everytime there is a stopping
    # point in simulated execution
    set canvas $window.canvas
    set h [winfo height $canvas]

    if {$h > 500 } {
	set currentTextFont $BIG_TEXT_FONT
	set currentLeading $BIG_LEADING
	set currentXoff $BIG_XOFF
    } elseif {$h >= 420} {
	set currentTextFont $MEDIUM_TEXT_FONT
	set currentLeading $MEDIUM_LEADING
	set currentXoff $MEDIUM_XOFF
    } elseif {$h >= 300} {
	set currentTextFont $SMALL_TEXT_FONT
	set currentLeading $SMALL_LEADING
	set currentXoff $SMALL_XOFF
    } else {
	set currentTextFont $TINY_TEXT_FONT
	set currentLeading $TINY_LEADING
	set currentXoff $TINY_XOFF
    }
    # useful info
    # puts "height: $h; leading: $currentLeading font: $currentTextFont"
    if {[info exists unitList]} {
	# puts "READY SET GO"
	#
	# clean out the IFQ first
	#
	foreach name $unitList {
	    switch -glob -- $name {
		box:*/* {
		    regexp -- {^box:([^/]*)/(.*)$} $name whole unit part
		    # puts "unit:part=$unit:$part"
		    # unit_display $canvas $unitInfo($name) $h "sub:$unit" $part
		}
		default {
		    # unit_display $canvas $unitInfo($name) $name}
		}
	    }

	    process_ifq_info $canvas $h

	    process_ruu_info $canvas $h

	    process_lsq_info $canvas $h

	    process_fu_info $canvas $h
    }
    return $canvas
}
