# SimpleScalar Visualization Engine
# Thumbnail display Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

# Certain global variables to control the thumbnail display functions.

global ThumbsFor ThumbOptions

# Initialization routine for the global variables.

proc init_thumbnail {} {

    global ThumbsFor

    set ThumbsFor [list d1c i1c bpb]

}


# The procedure that actually displays the thumbnail.

proc display_thumbnail {label CalledFromSystemRedraw {optionarray ""} } {
    # puts "display_thumbnail: here"

}
proc old_display_thumbnail {label CalledFromSystemRedraw {optionarray ""} } {

    global unitInfo
    global ThumbOptions

    # Read up the options into temporaries.

    if { $CalledFromSystemRedraw == 1 } {

	upvar $optionarray optionlist

	set xlo $optionlist(xlo); set ThumbOptions(${label}_xlo) $xlo
	set ylo $optionlist(ylo); set ThumbOptions(${label}_ylo) $ylo
	set xhi $optionlist(xhi); set ThumbOptions(${label}_xhi) $xhi
	set yhi $optionlist(yhi); set ThumbOptions(${label}_yhi) $yhi

    } else {

	set xlo $ThumbOptions(${label}_xlo)
	set ylo $ThumbOptions(${label}_ylo)
	set xhi $ThumbOptions(${label}_xhi)
	set yhi $ThumbOptions(${label}_yhi)

    }

    if { $CalledFromSystemRedraw != 1 || \
	    [winfo exists .${label}_thumbnail] } {

	destroy .${label}_thumbnail

	toplevel .${label}_thumbnail
	
	# Bind the Enter and Leave mouse events to the corresponding
	# help message display and remove functions.
	
	bind .${label}_thumbnail <Enter> [list \
		display_help_message .${label}_thumbnail .helpmesg]
	
	bind .${label}_thumbnail <Leave> [list \
		remove_help_message .helpmesg]
	
	if { [expr $xhi-$xlo] > [expr $yhi-$ylo] } {
	
	    # Create the rectangle to display the current value of 
	    # the statistic.
	
	    set XL [expr $xlo+60]
	    set XH [expr $xhi-10]
	    set YL [expr ($yhi+$ylo)/2-3]
	    set YH [expr ($yhi+$ylo)/2+3]
	    
	    canvas .${label}_thumbnail.canvas -bd 0 -bg white \
		    -width [expr $XH-$XL+10] -height [expr $YH-$YL+12]
	    set TCanvas .${label}_thumbnail.canvas
	    
	    $TCanvas create rectangle 5 5 [expr $XH-$XL+5] [expr $YH-$YL+5] \
		    -outline black -fill white -tags ${label}_thumb_r1
	    
	    $TCanvas create rectangle 0 0 0 0 -outline black -fill blue \
		    -tags ${label}_thumb_r2
	    $TCanvas create text 5 [expr $YH-$YL+9] -text 0
	    $TCanvas create text [expr $XH-$XL+8] [expr $YH-$YL+9] -text 1
	    
	    set LineAt [expr 5+($XH-$XL)/10]
	    for { set i 0 } { $i < 9 } { set i [expr $i+1] } {
		
		if { $i == 4 } {
		    $TCanvas create line $LineAt [expr $YH-$YL+11] $LineAt \
			    [expr $YH-$YL+5]
		} else {
		    $TCanvas create line $LineAt [expr $YH-$YL+8] $LineAt \
			    [expr $YH-$YL+5]
		}
		
		set LineAt [expr $LineAt+($XH-$XL)/10]
		
	    }
	    
	    pack $TCanvas
	    
	} else {
	    
	    # Create the rectangle that displays the value of the statistic.
	    
	    set XL [expr ($xhi+$xlo)/2-3]
	    set XH [expr ($xhi+$xlo)/2+3]
	    set YL [expr $ylo+20]
	    set YH [expr $yhi-20]
	    
	    canvas .${label}_thumbnail.canvas -bd 0 -bg white \
		    -width [expr $XH-$XL+12] -height [expr $YH-$YL+10]
	    set TCanvas .${label}_thumbnail.canvas
	    
	    $TCanvas create rectangle 5 5 [expr $XH-$XL+5] [expr $YH-$YL+5] \
		    -outline black -fill white -tags ${label}_thumb_r1
	    $TCanvas create rectangle 0 0 0 0 -outline black -fill blue \
		    -tags ${label}_thumb_r2	
	    $TCanvas create text [expr $XH-$XL+9] 7 -text 1
	    $TCanvas create text [expr $XH-$XL+9] [expr $YH-$YL+5] -text 0
	    
	    set LineAt [expr 5+($YH-$YL)/10]
	    for { set i 0 } { $i < 9 } { set i [expr $i+1] } {
		
		if { $i == 4 } {
		    $TCanvas create line [expr $XH-$XL+5] $LineAt \
			    [expr $XH-$XL+11] $LineAt
		} else {
		    $TCanvas create line [expr $XH-$XL+5] $LineAt \
			    [expr $XH-$XL+8] $LineAt
		}
		set LineAt [expr $LineAt+($YH-$YL)/10]
		
	    }
	    
	    pack $TCanvas
	    
	}

	wm overrideredirect .${label}_thumbnail 1
	wm withdraw .${label}_thumbnail

    }

    return 1
}

proc display_thumbnail_data {canvas} {
    # puts "display_thumbnail_data: here"
}
proc old_display_thumbnail_data {canvas} {
    
    global ThumbsFor ThumbOptions

    foreach label $ThumbsFor {

	if { [winfo exists .${label}_thumbnail] } {

	    # Read up the options into temporaries.

	    set xlo $ThumbOptions(${label}_xlo)
	    set ylo $ThumbOptions(${label}_ylo)
	    set xhi $ThumbOptions(${label}_xhi)
	    set yhi $ThumbOptions(${label}_yhi)

	    # Adjust the location of the thumbnail window appropriately.
	    
	    set RootX [winfo rootx $canvas]
	    set RootY [winfo rooty $canvas]

	    if { [expr $xhi-$xlo] > [expr $yhi-$ylo] } {
			
		set XL [expr $xlo+60]
		set YL [expr ($yhi+$ylo)/2-3]
		set myx [expr round($RootX+$XL-5)]
		set myy [expr round($RootY+$YL-6)]

	    } else {
			
		set XL [expr ($xhi+$xlo)/2-3]
		set YL [expr $ylo+20]
		set myx [expr round($RootX+$XL-6)]
		set myy [expr round($RootY+$YL-5)]

	    }

	    if { $myx != [winfo rootx .${label}_thumbnail] || \
		    $myy != [winfo rooty .${label}_thumbnail] } {

		wm withdraw .${label}_thumbnail
		wm geometry .${label}_thumbnail +$myx+$myy
		wm deiconify .${label}_thumbnail

	    }

	    raise .${label}_thumbnail .

	    set TCanvas .${label}_thumbnail.canvas

	    # Get the corresponding statistic name.
    
	    switch -exact $label {
		
		"d1c" {
		    
		    set CacheName [ss::getOption "-cache:dcache"]
		    set StatName "${CacheName}.miss_rate"
		    
		}
		
		"i1c" {
		    
		    set CacheName [ss::getOption "-cache:icache"]
		    set StatName "${CacheName}.miss_rate"
		    
		}
		
		"bpb" { 
		    
		    set PredictorType [ss::getOption "-bpred"]
		    set PredictorType "bpred_${PredictorType}"
		    set StatName "${PredictorType}.bpred_dir_rate"
		    
		}
		
	    }

	    if { [expr $xhi-$xlo] > [expr $yhi-$ylo] } {
	
		set XH [expr $xhi-10]
		set YH [expr ($yhi+$ylo)/2+3]

		# Display the bar so as to reflect the latest value of the 
		# statistic.
    
		for {set i 1} {$i < [llength $::allCycles]} \
			{set i [expr $i+1]} {

		    set currY [stat_value ::allStatistics $StatName [expr -$i]]

		    if { [string compare $currY ""] != 0 } {
			
			# Display the hit-rates for the caches.

			switch -exact $label {
			    
			    "d1c" -
			    "i1c" { set currY [expr {1-$currY}] }
			    
			}
			
			set Val [expr 5+$currY*($XH-$XL)]
			$TCanvas coords ${label}_thumb_r2 5 5 $Val \
				[expr $YH-$YL+5]
			$TCanvas coords ${label}_thumb_r1 $Val 5 \
				[expr $XH-$XL+5] [expr $YH-$YL+5]

			break
		    }

		}

	    } else {

		set XH [expr ($xhi+$xlo)/2+3]
		set YH [expr $yhi-20]
		
		# Display the bar so as to reflect the latest value of the
		# statistic.
		
		for {set i 1} {$i < [llength $::allCycles]} \
			{set i [expr $i+1]} {
		    
		    set currY [stat_value ::allStatistics $StatName [expr -$i]]

		    # Display the hit-rates for the caches.
		    
		    if { [string compare $currY ""] != 0 } {
			
			switch -exact $label {
			    
			    "d1c" -
			    "i1c" { set currY [expr {1-$currY}] }
			    
			}
			
			set Val [expr 5+(1-$currY)*($YH-$YL)]
			$TCanvas coords ${label}_thumb_r1 5 5 \
				[expr $XH-$XL+5] $Val
			$TCanvas coords ${label}_thumb_r2 5 $Val \
				[expr $XH-$XL+5] [expr $YH-$YL+5]

			break
		    }
		    
		}
	    
	    }
	    
	}
	
    }
    
    return 1

}


# Procedure that actually deactivates the thumbnail.

proc deact_thumbnail {label} {

    destroy .${label}_thumbnail

}


