# SimpleScalar Visualization Engine
# Tool Button Functions
#
# A tool button is megawidget with an action function and a canvas
# label.  The label must be painted with Tk canvas functions.  The
# action function may be an arbitrarily defined Tcl function.
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#
# Toolbutton options:
#
# Colors first

global activeColor
global tbBackgroundColor
global fgBackgroundColor

# option add *Toolbutton.activeColor orange   widgetDefault
option add *Toolbutton.activeColor $activeColor   widgetDefault
option add *Toolbutton.background  $tbBackgroundColor  widgetDefault

option add *Toolbutton.borderWidth 2      widgetDefault
option add *Toolbutton.padx        2      widgetDefault
option add *Toolbutton.pady        2      widgetDefault
# option add *Toolbutton.padx        8      widgetDefault
# option add *Toolbutton.pady        8      widgetDefault
option add *Toolbutton.press       sunken widgetDefault
option add *Toolbutton.relief      raised widgetDefault

option add *Toolbutton.Canvas.background $tbBackgroundColor widgetDefault
option add *Toolbutton.Canvas.foreground $tbForegroundColor widgetDefault
option add *Toolbutton.Canvas.height     10m   widgetDefault
option add *Toolbutton.Canvas.width      10m   widgetDefault
option add *Toolbutton.Canvas.padx       2     widgetDefault
option add *Toolbutton.Canvas.pady       2     widgetDefault

#-----------------------------------------------------------------------#

proc toolbutton_create {window paint action} {
    frame $window -class Toolbutton

    bind $window <Enter> [list toolbutton_enter $window]
    bind $window <Leave> [list toolbutton_leave $window]

    set padx [option get $window padx {}]
    set pady [option get $window pady {}]

    set canvas $window.canvas
    canvas $canvas
    pack $canvas -padx $padx -pady $pady

    bind $canvas <ButtonPress-1>   [list toolbutton_press   $window $action]
    bind $canvas <ButtonRelease-1> [list toolbutton_release $window]

    set xlo [expr [option get $canvas padx {}]+1.0]
    set ylo [expr [option get $canvas pady {}]+1.0]

    set xhi [expr [winfo reqwidth  $canvas]-$xlo-1.0]
    set yhi [expr [winfo reqheight $canvas]-$ylo-1.0]

    $paint $canvas $xlo $xhi $ylo $yhi

    return $window
}
proc toolbutton_enter {window} {
    
    # Highlight the active toolbutton.
    set color [option get $window activeColor {}]
    $window configure -background $color

    # Display its functionality in the status box.
    display_help_message $window .helpmesg
}
proc toolbutton_leave {window} {

    # Remove the highlight from the window.
    set color [option get $window background {}]
    $window configure -background $color

    # Remove the displayed help message.
    remove_help_message .helpmesg

}
proc toolbutton_press {window action} {
    set relief [option get $window press {}]
    $window configure -relief $relief
    $action $window
}
proc toolbutton_release {window} {
    set relief [option get $window relief {}]
    $window configure -relief $relief
}
