# SimpleScalar Visualization Engine
# Unit Display Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

# source "$env(VISUAL_SOURCE_DIR)/unitset.tcl"
source "ui/unitset.tcl"

#-----------------------------------------------------------------------#
proc unit_unused {canvas font label name tags xlo ylo xhi yhi fillColor } {
    global unitInfo
    global mainBackgroundColor
    global unusedCellInfo
    set oColor $mainBackgroundColor
    set fullname "unused:$name"

    if {[info exists unitInfo($fullname)]} {
	set idnt $unitInfo($fullname)
	$canvas coords $idnt $xlo $ylo $xhi $yhi
    } else {
	set ltag [concat unused $fullname $name $tags]
	set idnt [$canvas create rectangle $xlo $ylo $xhi $yhi -outline $oColor -width 1 -fill $fillColor -tags $ltag]
	set unitInfo($fullname) $idnt
	set unusedCellInfo($fullname) $idnt
    }
    set down [font metrics $font -descent]
    set labname "label/${fullname}"
    if {[info exists unitInfo($labname)]} {
	set idnt $unitInfo($labname)
	$canvas coords $idnt [expr {$xlo+$down}] $ylo
    } elseif {[string length $label] > 0} {
	set ltag [concat label $labname $tags]
	set idnt \
	    [$canvas create text [expr {$xlo+$down}] $ylo \
	        -anchor nw -font $font -tags $ltag -text "$label"]
	set unitInfo($labname) $idnt
    }
    return $fullname
}
proc unit_key {canvas font label name tags xlo ylo xhi yhi fillColor } {

    global unitInfo

    global stopArrowColor
    set oColor $stopArrowColor

    set fullname "key:$name"

    if {[info exists unitInfo($fullname)]} {

	set idnt $unitInfo($fullname)
	$canvas coords $idnt $xlo $ylo $xhi $yhi
	
    } else {

	set ltag [concat box $fullname $name $tags]
	set idnt [$canvas create rectangle $xlo $ylo $xhi $yhi -outline $oColor -width 1 -fill $fillColor -tags $ltag]
	set unitInfo($fullname) $idnt

    }

    set down [font metrics $font -descent]
    set labname "label/${fullname}"

    # puts "rectangle: (x,y) to (z,u): ($xlo,$ylo) to ($xhi,$yhi)"
    set xstart [expr {$xlo + ($xhi-$xlo)/4}] 
    set ystart [expr {$ylo + ($yhi - $ylo)/2}] 
    # puts "so start text at ($xstart,$ystart)"

    if {[info exists unitInfo($labname)]} {
	set idnt $unitInfo($labname)
	$canvas coords $idnt [expr {$xlo+$down}] $ylo
    } elseif {[string length $label] > 0} {
	set ltag [concat label $labname $tags]
	set idnt \
	    [$canvas create text $xstart $ystart \
	        -anchor nw -font $font -tags $ltag -text "$label"]
	set unitInfo($labname) $idnt
    }
    return $fullname
}

# If the argument 'thumb' is 1, it displays the thumbnail. If it is 0, 
# the original box is displayed.

proc unit_box {canvas font label name tags xlo ylo xhi yhi thumb} {

    global unitInfo

    global stopArrowColor
    set oColor $stopArrowColor

    set fullname "box:$name"

    if {[info exists unitInfo($fullname)]} {

	set idnt $unitInfo($fullname)
	$canvas coords $idnt $xlo $ylo $xhi $yhi
	
	if { $thumb == 1 } {

	    set OptionArray(xlo) $xlo
	    set OptionArray(ylo) $ylo
	    set OptionArray(xhi) $xhi
	    set OptionArray(yhi) $yhi

	    display_thumbnail $name 1 OptionArray

	}

    } else {

	set ltag [concat box $fullname $name $tags]
	set idnt [$canvas create rectangle $xlo $ylo $xhi $yhi -outline $oColor -width 1 -tags $ltag]
	set unitInfo($fullname) $idnt

    }
    set down [font metrics $font -descent]
    set labname "label/${fullname}"

    if {[info exists unitInfo($labname)]} {
	set idnt $unitInfo($labname)
	$canvas coords $idnt [expr {$xlo+$down}] $ylo
    } elseif {[string length $label] > 0} {
	set ltag [concat label $labname $tags]
	set idnt \
	    [$canvas create text [expr {$xlo+$down}] $ylo \
	        -anchor nw -font $font -tags $ltag -text "$label"]
	set unitInfo($labname) $idnt
    }
    return $fullname
}
proc unit_bus {canvas src dst tags xsrc ysrc xdst ydst} {
    global unitInfo

    set name "${src}->${dst}"
    set fullname "bus:${name}"
    set ltag [concat bus $fullname $name $src $dst $tags]
    set long [expr {hypot($xdst-$xsrc,$ydst-$ysrc)}]
    set half [expr {0.5*$long}]
    set wide [expr {0.6*$long}]
    set join [expr {0.2*$long}]

    if {[info exists unitInfo($fullname)]} {
	set idnt $unitInfo($fullname)
	$canvas coords $idnt $xsrc $ysrc $xdst $ydst
	$canvas itemconfigure $idnt \
		-arrow last -arrowshape [list $half $half $join] \
		-width $wide
    } else {
	set idnt \
		[$canvas create line $xsrc $ysrc $xdst $ydst \
		 -arrow last -arrowshape [list $half $half $join] \
		 -tags $ltag -width $wide]
	set unitInfo($fullname) $idnt
    }
    return $fullname
}

proc unit_fnu {canvas box} {
    set font [option get $canvas boxFont {}]

    set fadd [ss::getOption "-res:fpalu"]
    set fmul [ss::getOption "-res:fpmult"]
    set iadd [ss::getOption "-res:ialu"]
    set imul [ss::getOption "-res:imult"]

    unit_grid $canvas $box [expr {$fadd+$fmul+$iadd+$imul}]

    $canvas delete "fnu/temp"

    proc sub {base count label abbr args} {
	global fnuLabel
	global unitInfo
	global FUInfo
	upvar box box canvas canvas font font
	for {set n 0} {$n < $count} {incr n} {
	    set part [expr {$base+$n}]
	    set name "box:$box/$part"
	    set unit $unitInfo(box:$box/$part)
	    set tags [$canvas gettags $unit]
	    foreach tag [concat $args "sub:$abbr" "$abbr/$n"] {
		$canvas dtag $unit $tag
		$canvas addtag $tag withtag $unit
	    }
	    $canvas dtag $unit "sub:fnu"
	    foreach {xlo ylo xhi yhi} [$canvas bbox $unit] {}
	    set x [expr {0.5*($xlo+$xhi)}]
	    set y [expr {0.5*($ylo+$yhi)}]

	    if {[info exists fnuLabel($unit)]} {
		$canvas coords $fnuLabel($unit) $x $y
	    } elseif {[string length $label] > 0} {
		lappend tags "label" "sub:$abbr" "$abbr/$n"
		set fnuLabel($unit) \
		    [$canvas create text $x $y \
		        -font $font -tags $tags -text $label]
	    }
	    # set FUInfo(${n},${label}) $fnuLabel($unit)
	    set FUInfo(${n},${label}) $unit
	    # puts "FUInfo($n:$label)=$FUInfo(${n},${label})"
	    set name "box:$abbr/$n"
	    set unitInfo($name) $unit
	    lappend result $name
	}
	return $result
    }

    return [concat \
	[sub 0                        $fadd "F+F" fpalu  float   adder] \
	[sub $fadd                    $fmul "FxF" fpmult float   multiplier] \
	[sub [expr $fadd+$fmul]       $iadd "I+I" ialu   integer adder] \
	[sub [expr $fadd+$fmul+$iadd] $imul "IxI" imult  integer multiplier]]
}

proc unit_grid {canvas box number} {
    global mainBackgroundColor
    # puts "grid for $box this many: $number"
    set rect [$canvas find withtag "box:${box}"]
    foreach {xlo ylo xhi yhi} [$canvas bbox $rect] {}

    set xhi [expr {$xhi-1}]
    set yhi [expr {$yhi-1}]
    set xlo [expr {$xlo+1}]
    set ylo [expr {$ylo+1}]

    if {! [catch {$canvas find withtag "label/box:${box}"}]} {
	set font [option get $canvas boxFont {}]
	set high [font metrics $font -linespace]
	set ylo [expr {$ylo+$high}]
    }

    set high [expr {$yhi-$ylo}]
    set wide [expr {$xhi-$xlo}]

    proc badness {r c} {
	upvar number number high high wide wide
	set h [expr {double($high)/$r}]
	set w [expr {double($wide)/$c}]
	return [expr {6.0*($r*$c-$number)*$h*$w+$number*abs($h*$h-$w*$w)}]
    }

    for {set row 1} {$row*$row<$number} {incr row} {
	set col [expr {int(ceil(double($number)/$row))}]
	set bad [badness $row $col]
	if {! [info exists best]}    {set best [list $bad $row $col]}
	if {$bad < [lindex $best 0]} {set best [list $bad $row $col]}
	set bad [badness $col $row]
	if {$bad < [lindex $best 0]} {set best [list $bad $col $row]}
    }

    set row [expr {int(ceil(sqrt(double($number))))}]
    set bad [badness $row $row]
    if {$bad < [lindex $best 0]} {set best [list $bad $row $row]}

    foreach {bad row col} $best {}

    set h [expr {double($high)/$row}]
    set w [expr {double($wide)/$col}]

    set font [option get $canvas numFont {}]
    set ltag [lappend [$canvas gettags $rect] "sub" "sub:$box"]

    for {set n 0} {$n < $number} {incr n} {
	set c [expr {$n % $col}]
	set r [expr {$n / $col}]
	set lx [expr {$xlo+$c*$w}]
	set ly [expr {$ylo+$r*$h}]
	set hx [expr {$lx+$w}]
	set hy [expr {$ly+$h}]
	# puts "this box: ($lx, $ly) to ($hx, $hy)"
	unit_box $canvas $font "$n" "$box/$n" $ltag $lx $ly $hx $hy 0
	lappend result "box:$box/$n"
    }
    set totCells [expr {$row * $col}]
    set unusedCells [expr {$totCells - $number}]

    for {set n $number} {$n < $totCells} {incr n} {
	set c [expr {$n % $col}]
	set r [expr {$n / $col}]
	set lx [expr {$xlo+$c*$w}]
	set ly [expr {$ylo+$r*$h}]
	set hx [expr {$lx+$w}]
	set hy [expr {$ly+$h}]

	set ltag [lappend [$canvas gettags $rect] "unused" "unused:$box"]
	# puts "New and unused: ($lx, $ly) to ($hx, $hy)"
	# don't include a label
	unit_unused $canvas $font "" "$box/$n" $ltag $lx $ly $hx $hy \
	    $mainBackgroundColor
	lappend result "unused:$box/$n"
    }
    return $result
}

proc unit_setting {canvas x y} {
    set idnt [$canvas find closest $x $y]
    set tags [$canvas gettags $idnt]
    set indx [lsearch -regexp $tags {^(label/)?(box|bus|unused|sub):[^/]*$}]
    if {$indx >= 0} {
	regexp {(box|bus|sub):[^/]*$} [lindex $tags $indx] tag
	unitset_open $tag
    }
    return $canvas
}
proc unit_stat {unit_name} {
    set xOffset "Unk"
    set yOffset "Unk"
    # puts "unit name: $unit_name"
    switch -exact $unit_name {
	ruu {
	    display_statistics ruu $xOffset $yOffset 0
	}
	lsq {
	    display_statistics lsq $xOffset $yOffset 0
	}
	ifq {
	    display_statistics ifq $xOffset $yOffset 0
	}
	default {
	}
    }
}
proc unit_show {canvas x y} {

    # Currently, invoked when we click on the individual boxes,
    # like the IFQ boxes -- set up by system_create() for the canvas
    #
    set id [$canvas find closest $x $y]
    set X [expr {$x+[winfo rootx $canvas]}]
    set Y [expr {$y+[winfo rooty $canvas]}]
    
    # Get the item type, its name and number. Use that info to call the
    # appropriate routine in the switch statement.
    # To be refined as and when appropriate.

    set Tags  [$canvas gettags $id]
    # puts "id: $id; tags: $Tags"
    set Index [lsearch -regexp $Tags {.*:.*\/[0-9]+}]
    if {$Index == -1} {
	set Index [lsearch -regexp $Tags {.*:.*}]
    }
    set MyTag [lindex $Tags $Index]

    if {![regexp {(.*):(.*)\/([0-9]+)} $MyTag EntireString ItemType \
	    ItemName ItemNumber]} {
	regexp {(.*):(.*)} $MyTag EntireString ItemType ItemName
    }
    # Set the offsets to "Unk" (Unknown) to let the display code
    # decide where to map the window.
    set xOffset "Unk"
    set yOffset "Unk"
    # puts "Item: $ItemName, Type: $ItemType"
    switch -exact $ItemName {
	bpb {
	    display_statistics "branch prediction" $xOffset $yOffset 0
	}
	btb {
	    display_statistics "branch prediction" $xOffset $yOffset 0
	}
	ifq { 
	     display_statistics ifq $xOffset $yOffset 0
	}
	itlb {
	    display_statistics itlb $xOffset $yOffset 0
	}
	i1c { 
	    display_statistics il1 $xOffset $yOffset 0
	}
	d1c { 
	    display_statistics dl1 $xOffset $yOffset 0
	}
	ruu {
	    display_statistics ruu $xOffset $yOffset 0
	}
	lsq {
	    display_statistics lsq $xOffset $yOffset 0
	}
	dtlb {
	    display_statistics dtlb $xOffset $yOffset 0
	}
	fnu {
	    no_statistics fnu "Adder/Multiplier" 2
	}
	l2c {
	    no_statistics l2c "L2 Cache" 1 
	}
	mem {
	    display_statistics misc $xOffset $yOffset 0
	}
	default {
	    display_statistics sys $xOffset $yOffset 0
	}
    }
    return $canvas
}

#-----------------------------------------------------------------------#

proc unit_aliasDelta {statistic {last -1} {prev -2}} {
    set l [stat_value ::allStatistics $statistic $last]
    set p [stat_value ::allStatistics $statistic $prev]
    return [expr {$l-$p}]
}

proc unit_aliasValue {name} {

    if {[string index "$name" 0] == "-"} {
	if {[catch {ss::getOption "$name"} value]} {
	    return {}
	}
	return $value
    }

    if {[catch {ss::getStatistic "$name"} value]} {
	return {}
    }
    return $value
}
proc unit_display {canvas ident wheight unit {part 0}} {
    # This function is invoked every time we turn the crank,
    # that is, every time the cycle counter goes 'round
    # it is invoked for each unit or cell or box in the larger components
    global fnuLabel
    global lastIFQInfo
    global canvasLabelColor
    global canvasSubColor
    global textHighlightColor 
    global currentTextFont
    global currentLeading
    global currentXoff

    set fColor $canvasLabelColor
    set highlightColor $textHighlightColor
    set tfont $currentTextFont
    set leading [expr $currentLeading]
    set xOff $currentXoff

    set setting [unitset_getdata $unit]
    #   Notes:
    #
    #   $ident is the unique integer identifier for each unit in
    #   the canvas, from 2 to 180 or whatever
    #
    #   $unit is lsq, mem, l2c, i1c, d1c, itlb, dtlb, ialu, fpmult
    #       fpalu, fnu, ruu, ifq, etc.
    #
    #   For example, {$unit == "sub:ifq"} 
    #
    #   $part is the little box of the component
    #
    foreach {index value} $setting {
	switch -exact -- $index {
	    -code    {set script $value}
	    -color   {set colors $value}
	    -default {set normal $value}
	}
    }
    set parser [interp create -safe]

    $parser alias delta unit_aliasDelta
    $parser alias value unit_aliasValue

    $parser eval "set unit $unit"
    $parser eval "set part $part"

    if {! [catch {$parser eval $script} value]} {
	if {[string is double -strict $value]} {
	    catch {
		foreach {pair} $colors {
		    foreach {limit color} $pair {}
		    if {! [string is double -strict $limit]} {break}
		    if {[string length $color] < 1} {break}
		    if {$value > $limit} {
			set filler $color
			break
		    }
		}
	    }
	}
	if {! [info exists filler] && [info exists normal]} {
	    set filler $normal
	}
    }
    if {[info exists filler]} {
	catch {$canvas itemconfigure $ident -fill $filler}
    } elseif {[info exists normal]} {
	catch {$canvas itemconfigure $ident -fill $normal}
    } else {
	# puts "errors: $canvas $ident $unit/$part"
    }
    switch -exact $unit {
	sub:ifq { 
	    set DisplayString [ss::getIFQItem $part] 
	    if {([string last "H:0" $DisplayString] > -1 )} {
		set H 0
	    } elseif {([string last "H:1" $DisplayString] > -1 )} {
		set H 1
	    } elseif {([string last "H:2" $DisplayString] > -1 )} {
		set H 2
	    } else {
		set H 3
	    }
	    # Time to massage the DisplayString
	    regexp {(.*)Instruction -(.*)Current PC - (.*)} $DisplayString EntireString Throwaway Instruction CPC
	    string trim $CPC
	    #
	    # Instruction is now of the goofy form:
	    #
	    #       space\nOPCODE8spacesOPS\n\n
	    #
            if {! [string compare $CPC "0x0 "]} {
		# do nothing -- it's invalid
	    } else {
		set fre " \n(.*)"
		set match [regexp $fre $Instruction EntireString FirstPart]
		# puts $FirstPart
		set fre "(\[a-z\]+)(.*)"
		set match [regexp $fre $FirstPart EntireString Opcode Rest]
		set fre "( +)(.*)(\n\n)"
		set match [regexp $fre $Rest EntireString Spaces Operands End]
		if { [ info exists Opcode ] } {
		    set listCoords [$canvas coords $ident]
		    set myX [expr [lindex $listCoords 0] + $xOff]
		    set myY [expr [lindex $listCoords 1] + $leading ]
                    switch $H {
			"0" {
			    set Opcode "HT>${Opcode}"
			}
			"1" {
			    set Opcode "H>>${Opcode}"
			}
			"3" {
			    set Opcode "T>>${Opcode}"
			}
		    }
		    if {[info exists lastIFQInfo(CPC$ident)]} {
			#
			# then presumably we've already created the text
			# widgets.  So dandy: just re-configure them.
			#
			set CPCId $lastIFQInfo(CPC$ident)
			set OpcId  $lastIFQInfo(Opc$ident)
			set OperId $lastIFQInfo(Oper$ident)

			$canvas itemconfigure $CPCId -fill $textHighlightColor \
			    -anchor nw  -font $tfont -width 58 \
			    -text "$CPC"

			$canvas itemconfigure $OpcId -fill $textHighlightColor \
			    -anchor nw  -font $tfont \
			    -text "$Opcode" 

			$canvas itemconfigure $OperId -fill $textHighlightColor \
			    -anchor nw  -font $tfont -width 60 \
			    -text "$Operands"
			# puts "Old: $ident:$CPCId=$CPC $Opcode $Operands"

		    } else {
			# create the text widgets and
			# store their IDs
			set listCoords [$canvas coords $ident]
			set myX [expr [lindex $listCoords 0] + $xOff]
			set myY [expr [lindex $listCoords 1] + $leading ]
			set CPCId [$canvas create text \
			    $myX $myY -fill $textHighlightColor \
			    -anchor nw  -font $tfont -text "$CPC"]
			set OpcId [$canvas create text \
			    $myX [expr $myY + $leading ] -fill $textHighlightColor \
			    -anchor nw  -font $tfont -text "$Opcode" ]
			set OperId [$canvas create text \
			    $myX [expr $myY + $leading * 2 ]\
			    -fill $textHighlightColor -anchor nw  \
			    -font $tfont -width 60 -text "$Operands"]
			    # To pop up the statistics window when the user presses
			    # on the overlaid text...
			    $canvas bind $CPCId <Button-1> [list unit_stat "ifq"]
			    $canvas bind $OpcId <Button-1> [list unit_stat "ifq"]
			    $canvas bind $OperId <Button-1> [list unit_stat "ifq"]
			# now remember
			set lastIFQInfo(CPC$ident) $CPCId
			set lastIFQInfo(Opc$ident) $OpcId
			set lastIFQInfo(Oper$ident) $OperId
			# puts "NEW: $ident:$CPCId=$CPC $Opcode $Operands"
		    }
		} else {
		    # we've got no opcode -- forgetaboutit
		}
	    }
	}
	sub:ruu {
	}
	default {
	}
    }
    interp delete $parser
    if {[info exists script] && ! [string is double -strict $value]} {
	puts "unit_display $unit/$part -> $value"
    }
    return $value
}

