# SimpleScalar Visualization Engine
# Unit Setting Functions
#
# *** PUT COPYRIGHT STUFF HERE ***
#=======================================================================#

package require Tk 8.0

#-----------------------------------------------------------------------#

global unitBackgroundColor
global unitForegroundColor

option add *Unitset*borderWidth	 	2       	widgetDefault
option add *Unitset*relief	 	flat    	widgetDefault

option add *Unitset*Button*relief	raised  	widgetDefault

# option add *Unitset*Entry*background	white   	widgetDefault
option add *Unitset*Entry*background	$unitBackgroundColor   	widgetDefault
option add *Unitset*Entry*font		{Courier 12}   	widgetDefault
option add *Unitset*Entry*relief	sunken	  	widgetDefault

option add *Unitset*Label*relief	flat	  	widgetDefault

option add *Unitset*Setter.columns	6	  	widgetDefault
option add *Unitset*Setter.relief	raised  	widgetDefault

option add *Unitset*Text*background	$unitBackgroundColor   	widgetDefault
option add *Unitset*Text*foreground	$unitForegroundColor   	widgetDefault
# option add *Unitset*Text*background	white   	widgetDefault
# option add *Unitset*Text*foreground	black   	widgetDefault
option add *Unitset*Text*font		{Courier 12}   	widgetDefault
option add *Unitset*Text*relief		sunken  	widgetDefault

#-----------------------------------------------------------------------#

proc unitset_open {unit} {
    global unitSetting

    set unitset ".unitset${unit}"

    if {[winfo exists $unitset]} {
	catch {wm deiconify $unitset}
	catch {raise $unitset}
	catch {focus -force $unitset}
	return $unitset
    }

    toplevel $unitset -class Unitset

    wm title    $unitset "Unit Settings for $unit"
    wm iconname $unitset "Unit Set"

    #-----------------------------------------------------------------------#
    # First-level widgets:
    #
    set action $unitset.action
    set editor $unitset.editor
    set setter $unitset.setter

    frame $action -class Action
    frame $editor -class Editor
    frame $setter -class Setter

    pack $action -expand no  -fill x    -side top
    pack $setter -expand no  -fill x    -side bottom
    pack $editor -expand yes -fill both -side top

    #-----------------------------------------------------------------------#
    # Action buttons:
    #
    set apply  $action.apply
    set cancel $action.cancel
    set reset  $action.reset

    button $apply  -text "Apply"  -takefocus 0 \
	    -command [list unitset_apply $unit]
    button $cancel -text "Cancel" -takefocus 0 \
	    -command [list unitset_cancel $unit]
    button $reset  -text "Reset"  -takefocus 0 \
	    -command [list unitset_reset $unit]

    pack $apply  -expand yes -fill x -side left
    pack $cancel -expand yes -fill x -side left
    pack $reset  -expand yes -fill x -side left

    #-----------------------------------------------------------------------#
    # Editor:
    #
    set text $editor.text
    set xbar $editor.xbar
    set ybar $editor.ybar

    text $text -takefocus 0 \
	    -yscrollcommand [list $ybar set]

    scrollbar $ybar -orient vertical -takefocus 0 \
	    -command [list $text yview] 

    grid $text -row 0 -column 0 -sticky ensw
    grid $ybar -row 0 -column 1 -sticky ns

    #-----------------------------------------------------------------------#
    # Threshold/Color settings:
    #
    set clabel $setter.clabel
    set dentry $setter.dentry
    set dlabel $setter.dlabel
    set llabel $setter.llabel

    label $clabel -text "Color:"
    label $dlabel -text "default"
    label $llabel -text "Limit:"

    grid $llabel -column 0 -row 0 -sticky ew
    grid $clabel -column 0 -row 1 -sticky ew

    set maxcol [option get $setter columns {}]
    for {set col 1} {$col < $maxcol} {incr col} {
	set limit $setter.limit$col
	set color $setter.color$col
	entry $limit -width 11
	entry $color -width 11
	grid  $limit -column $col -row 0 -sticky ew
	grid  $color -column $col -row 1 -sticky ew
	bind  $color <Button-3> [list unitset_color $unitset $color]
    }
    entry $dentry -width 11

    set limit1 $setter.limit1

    grid $dlabel -column $maxcol -row 0 -sticky ew
    grid $dentry -column $maxcol -row 1 -sticky ew
    bind $dentry <Button-3> [list unitset_color $unitset $dentry]

    #-----------------------------------------------------------------------#
    # Fill window with data, if any:
    #
    unitset_data2pane $unitset [unitset_getdata $unit]

    if {! [info exists unitSetting($unit-system)]} {
	set unitSetting($unit-system) [unitset_pane2data $unitset]
    }

    #-----------------------------------------------------------------------#
    # Miscellaneous bindings:
    #
    bind $unitset <Control-c> [list unitset_cancel $unit]

    return $unitset
}

proc unitset_color {unitset entry} {
    set old [$entry get]

    if {[catch [tk_chooseColor -parent $unitset -initialcolor $old] new]} {
	set new [tk_chooseColor -parent $unitset]
    }

    if {[string length $new] != 0} {
	$entry delete 0 end
	$entry insert 0 $new
    }

    return $entry
}

proc unitset_apply {unit} {
    global unitSetting

    set unitset ".unitset${unit}"

    set old [unitset_getdata $unit]
    set new [unitset_pane2data $unitset]

    if {! [string equal $old $new]} {
	set unitSetting($unit-user) $new
	set unitSetting(MODIFIED) 1
	status_message .status "Modified unit update information for $unit"
    }

    destroy $unitset

    return $unitset
}

proc unitset_cancel {unit} {
    set unitset ".unitset${unit}"

    set old [unitset_getdata $unit]
    set new [unitset_pane2data $unitset]

    if {[string equal $old $new] || [unitset_loseData $unitset]} {
	destroy $unitset
    }

    return $unitset
}

proc unitset_reset {unit} {
    set unitset ".unitset${unit}"

    set old [unitset_getdata $unit]
    set new [unitset_pane2data $unitset]

    if {[string equal $old $new] || [unitset_loseData $unitset]} {
	unitset_data2pane $unitset $old
    }

    return $unitset
}

proc unitset_loseData {parent} {
    set answer \
	[tk_messageBox \
	    -default no \
	    -icon warning \
	    -message "Data has changed!\nContinue?" \
	    -parent $parent \
	    -type yesno]
    return [string equal -nocase $answer "yes"]
}

#-----------------------------------------------------------------------#

proc unitset_data2pane {pane data} {
    $pane.editor.text delete 1.0 end
    $pane.setter.dentry delete 0 end

    set maxc [option get $pane.setter columns {}]
    for {set c 1} {$c < $maxc} {incr c} {
	$pane.setter.color$c delete 0 end
	$pane.setter.limit$c delete 0 end
    }

    foreach {index value} $data {
	switch -exact -- $index {
	    -code {$pane.editor.text insert 1.0 [string trimright $value]}
	    -color {
		for {set c 1} {$c < $maxc} {incr c} {
		    foreach {limit color} [lindex $value [expr {$c-1}]] {}
		    $pane.setter.color$c insert 0 $color
		    $pane.setter.limit$c insert 0 $limit
		}
	    }
	    -default {$pane.setter.dentry insert 0 $value}
	}
    }

    return $pane
}

proc unitset_pane2data {pane} {
    set data [list "-code" [string trimright [$pane.editor.text get 1.0 end]]]

    set maxc [option get $pane.setter columns {}]
    set temp {}
    for {set c 1} {$c < $maxc} {incr c} {
	set limit $pane.setter.limit$c
	set color $pane.setter.color$c
	lappend temp [list [$limit get] [$color get]]
    }
    lappend data "-color" $temp

    lappend data "-default" [$pane.setter.dentry get]

    return $data
}

proc unitset_getdata {unit} {
    global unitSetting

    if {[info exists unitSetting($unit-user)]} {
	return $unitSetting($unit-user)
    }

    if {[info exists unitSetting($unit-system)]} {
	return $unitSetting($unit-system)
    }

    return {}
}

#-----------------------------------------------------------------------#

proc unitset_reader {filename {base "-user"}} {
    catch {
	set parser [interp create -safe]
	$parser alias setting unitset_setting $base
	$parser expose source source
	$parser eval [list source $filename]
    } result

    return $result
}

proc unitset_setting {base unit args} {
    global unitSetting

    if {[llength [.system.canvas find withtag $unit]] > 0} {
	set index "${unit}${base}"
	set unitSetting($index) $args
    }

    return $unit
}

proc unitset_writer {filename {base "-user"}} {
    global unitSetting

    set file [open $filename "w"]
    puts $file \
	"# Automatically generated -*-TCL-*- script; edit at your own risk!"
	
    foreach index [lsort [array names unitSetting "*$base"]] {
	regexp -- "^(.*)$base\$" $index temp unit
	puts $file "\nsetting $unit $unitSetting($index)"
    }
    catch {close $file}

    return $filename
}
