package CSV ;

use strict ;

our (@ISA, @EXPORT, @EXPORT_OK, $VERSION) ;

use Exporter;

@ISA = qw(Exporter);

$VERSION     = 1.00 ;
@EXPORT      = qw(&read_csv_table) ;
@EXPORT_OK   = qw() ;


# Input: CSV filename
# OUTFILE: (1) @$fieldname, (2) $N - the number of records, (3) $$records{"field name"}[$i] ;

sub read_csv_table {
  my ($infilename) = @_ ;

  open INFILE, $infilename or die "Cannot open file: $infilename" ;
  my $headerline = <INFILE> ;
  chomp $headerline;

  my @fieldname = split /,/, $headerline ;
  my %records ;

  my $n = 0 ;
  while(<INFILE>) {
    chomp ;
    my @L = split /,/ ;

    for(my $i = 0 ; $i < scalar @fieldname ; $i++) {
     push @{$records{$fieldname[$i]}}, $L[$i] ;
    }
    $n++ ;
  }

  close INFILE ;

  return (\@fieldname, $n, \%records) ;
}

1 ;
