#!/usr/bin/perl -w

use strict ;
use CSV ;

my $splitNum = 10 ;

foreach my $game ("ibs","icg","ipd") {
  print "Game=$game", "\n" ;

  my %avg_base ;
  my %avg_mca ;
  my %backup_mca ;

  my %totalGameNum_base ;
  my %totalGameNum_mca ;

  my %avgsq_base ;
  my %count_base ;
  my %CIbase ;
  my %lowerCI_base ;

  my %avgsq_mca ;
  my %count_mca ;
  my %CImca ;
  my %lowerCI_mca ;

  my %avgDupTraceNum ;
  my %avgTraceNum ;
  my %avgSolutionNum ;

  my $CONDOR_NUM = 100.0 ;
  my $F = 5 ;

  for(my $cid=0; $cid<$CONDOR_NUM; $cid++) {
    for(my $f=1; $f<=$F; $f++) {
      my ($fieldname0, $N0, $records0) = read_csv_table("statistics/${game}_f${f}_s${splitNum}_test_base_statistics.csv.condor${cid}") ;
      for(my $i=0; $i<$N0; $i++) {
        my $p = $$records0{"program"}[$i] ;
        my $a = $$records0{"avgscore"}[$i] ;

        $avg_base{$p} += $a ;
        $count_base{$p} += 1 ;
        $avgsq_base{$p} += $a * $a ;
        $totalGameNum_base{$p} += $$records0{"oppNum"}[$i] * $$records0{"repeatNum"}[$i] ;
      }

      my ($fieldname1, $N1, $records1) = read_csv_table("statistics/${game}_f${f}_s${splitNum}_test_mca_statistics.csv.condor${cid}") ;
      for(my $i=0; $i<$N1; $i++) {
        my $p = $$records1{"program"}[$i] ;
        my $a = $$records1{"avgscore"}[$i] ;

        $avg_mca{$p} += $a ;
        $count_mca{$p} += 1 ;
        $avgsq_mca{$p} += $a * $a ;
        $backup_mca{$p} += $$records1{"backupUsage"}[$i] / $$records1{"oppNum"}[$i] ;
        $totalGameNum_mca{$p} += $$records1{"oppNum"}[$i] * $$records1{"repeatNum"}[$i] ;
      }

      my ($fieldname2,$N2,$records2) = read_csv_table("statistics/${game}_f${f}_s${splitNum}_train_summary.csv.condor${cid}") ;
      $avgDupTraceNum{${game}} += $$records2{"DupTraceNum"}[0] ;
      $avgTraceNum{${game}} += $$records2{"TraceNum"}[0] ;
      $avgSolutionNum{${game}} += $$records2{"SolutionNum"}[0] ;
    }
  }

  foreach my $p0 (keys %avg_base) {
    my $p1 = "mca_$p0" ;

    # printf("%s: %d  %d\n", $p1, $count_base{$p0}, $count_mca{$p1}) ; 
    $avg_base{$p0} /= $count_base{$p0} ;
    $avgsq_base{$p0} /= $count_base{$p0} ;

    my $sd0 = sqrt( ($avgsq_base{$p0} - $avg_base{$p0} * $avg_base{$p0}) * $count_base{$p0} / ($count_base{$p0} - 1) ) ;
    $CIbase{$p0} = 1.96 * $sd0 / sqrt($count_base{$p0}) ;

    $avg_mca{$p1} /= $count_mca{$p1} ;
    $avgsq_mca{$p1} /= $count_mca{$p1} ;
    $backup_mca{$p1} /= $count_mca{$p1} ;

    my $sd1 = sqrt( ($avgsq_mca{$p1} - $avg_mca{$p1} * $avg_mca{$p1}) * $count_mca{$p1} / ($count_mca{$p1} - 1) ) ;
    $CImca{$p1} = 1.96 * $sd1 / sqrt($count_mca{$p1}) ;
  }

  $avgDupTraceNum{${game}} /= $CONDOR_NUM * $F ;
  $avgTraceNum{${game}} /= $CONDOR_NUM * $F ;
  $avgSolutionNum{${game}} /= $CONDOR_NUM * $F ;

  # OppNum,randOppNum,backupUsage

  open OUTFILE, ">${game}_s${splitNum}_stat.csv" ;
  printf OUTFILE "Base Agent,MCA Agent,Base Avg,MCA Avg,Diff,,Base CI,MCA CI,,Base Invoke %%\n" ;
  foreach my $p0 (sort { $avg_base{$b} <=> $avg_base{$a} } (keys %avg_base)) {
    my $p1 = "mca_${p0}" ;
    printf OUTFILE "%s,%s,%.5f,%.5f,%.5f,,%.5f,%.5f,,%.5f\n",
      $p0, $p1, $avg_base{$p0}, $avg_mca{$p1}, $avg_mca{$p1}-$avg_base{$p0},
      $CIbase{$p0}, $CImca{$p1}, $backup_mca{$p1};
  }
  close OUTFILE ;


  open OUTFILE, ">${game}_stat.R" ;
  print OUTFILE "${game}_diff = c(" ;
  my $first = 1; 
  foreach my $p0 (sort { $avg_base{$b} <=> $avg_base{$a} } (keys %avg_base)) {
    my $p1 = "mca_${p0}" ;
    if ($first==1) { $first = 0; } else { print OUTFILE ", " ; }
    printf OUTFILE "%.5f", $avg_mca{$p1}-$avg_base{$p0} ;
  }
  print OUTFILE ")\n\n" ;

#   print OUTFILE "${game}_a = [" ;
#   foreach my $p0 (sort { $avg_base{$b} <=> $avg_base{$a} } (keys %avg_base)) {
#     my $p1 = "mca_${p0}" ;
#     printf OUTFILE " %.5f", $avg_base{$p0} ;
#   }
#   print OUTFILE "] ;\n\n" ;
# 
#   print OUTFILE "${game}_b = [" ;
#   foreach my $p0 (sort { $avg_base{$b} <=> $avg_base{$a} } (keys %avg_base)) {
#     my $p1 = "mca_${p0}" ;
#     printf OUTFILE " %.5f", $avg_mca{$p1} ;
#   }
#   print OUTFILE "] ;\n\n" ;
# 
#   print OUTFILE "${game}_diff = [" ;
#   foreach my $p0 (sort { $avg_base{$b} <=> $avg_base{$a} } (keys %avg_base)) {
#     my $p1 = "mca_${p0}" ;
#     printf OUTFILE " %.5f", $avg_mca{$p1}-$avg_base{$p0} ;
#   }
#   print OUTFILE "] ;\n\n" ;

  close OUTFILE ;

  # count number of opponents

  my $avg_totalGameNum_base = 0.0 ;
  my $avg_totalGameNum_mca = 0.0 ;
  my $N = 0 ;
  foreach my $p0 (keys %avg_base) {
    my $p1 = "mca_${p0}" ;
    $avg_totalGameNum_base += $totalGameNum_base{$p0} ;
    $avg_totalGameNum_mca += $totalGameNum_mca{$p1} ;
    $N++ ;
  }

  $avg_totalGameNum_base /= $N ;
  $avg_totalGameNum_mca /= $N ;

  printf "In ${game}, the average number of traces (with duplicates) in the train set is %.2f\n", $avgDupTraceNum{${game}} ;
  printf "In ${game}, the average number of traces (without duplicates) in the train set is %.2f\n", $avgTraceNum{${game}} ;
  printf "In ${game}, the average number of traces in the solution of the CIT algorithm is %.2f\n", $avgSolutionNum{${game}} ;

  printf "In ${game}, the total number of games per base agent is %.2f\n", $avg_totalGameNum_base ;
  printf "In ${game}, the total number of games per mca agent is %.2f\n", $avg_totalGameNum_mca ;

}


