#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <rpc/rpc.h>
#include <errno.h>
#include "fs_interf.h"
#include "inode.h"
#include "fs.h"
#include "fh_hash.h"
#include "fileid_hash.h"

#include "stats.h"

#include "nfsd.h"
int minit(char *hostname, char *dirname) {

  int i;
  struct timeval t = {10, 0};
  struct fhstatus status;
  enum clnt_stat repval;

  CLIENT *clnt = clnt_create(hostname, MOUNTPROG, MOUNTVERS, "udp");

  if (!clnt) {
    fprintf(stderr, "clnt_create failed");
    return -1;
  }
 
  repval = clnt_call(clnt, PROCMNT,
                     (xdrproc_t)xdr_dirpath, (char *)&dirname,
                     (xdrproc_t)xdr_fhstatus, (char *)&status,
                     t);
 
  if (repval != RPC_SUCCESS) {
    perror("rpc mount");
    return -1;
  }

  if (status.status != 0) {
    fprintf(stderr, "mount: %s:%s failed, reason given by server:\n",
            hostname, dirname);
    return -1;
  }
}

int main() {
  minit("tacky","/home/kotla/test");
  printf("Mount is successful.\n");
}  
