#ifndef _LOCK_H
#define _LOCK_H 1

#include<stdio.h>
#include<pthread.h>
#include<stdlib.h>


// Class lock
class Lock {
private:
  pthread_mutex_t lck; // Mutex 
  pthread_cond_t  lck_cond ; // Condition variable associated with mutex

public:
  Lock() { 
    // Initialize mutex
    if (pthread_mutex_init(&lck,NULL)) {
      fprintf(stderr,"Cannot initialize pthread mutex successfully. \n");
      exit(-1);
    }
    
    // Initialize the condition variable
    if (pthread_cond_init(&lck_cond,NULL)) {
      fprintf(stderr,"Cannot initialize pthread cond successfully. \n");
      exit(-1);
    }
  }

  ~Lock() {
    // Destroy the mutex
    if (pthread_mutex_destroy(&lck)) {
      fprintf(stderr,"Cannot destroy pthread mutex successfully. \n");
    }
  }
  
  // Lock the mutex
  void lock() {
    pthread_mutex_lock(&lck);
  }

  // Unlock the mutex
  void unlock() {
    pthread_mutex_unlock(&lck);
  }

  // Wait for the condition variable
  void wait() {
    pthread_cond_wait(&lck_cond,&lck);
  }
  
  // Signals the threads blocked on cond variable
  // This just unblocks one thread.
  void signal() {
    pthread_cond_signal(&lck_cond);
  }

  // Broadcasts to the threads blocked on this cond variable
  void broadcast() {
    pthread_cond_broadcast(&lck_cond);
  }
};



#endif // _Lock_h
