#include "Parallelizer.h"
extern pthread_cond_t req_ready_cond;
extern pthread_mutex_t req_queue_mutex;
//FILE *log = 0; 
bool Parallelizer::insert(int cid, Request_id rid, Seqno num, Thread_arg *t) {
  // For now lets set the first arg as ready
  // Kotla : change it to blocked once we have prallelizer code
  Req *req = new Req(ready,cid,rid,num,t);
  std::list<Req*>::reverse_iterator iter;
  Lock *mutex = &req_queue.mutex;
  std::list<Req *> *li = &req_queue.obj;
  int op = 0;
  int fhandle = 0;
  bool same_client_dependency = false;
  

  // Extract optype and handle 
  read_state(t->inb,&op,&fhandle);
  // Set service specific state ( nfs for now)
  req->set_state(op,fhandle);
  
  mutex->lock();
 
  //#if 0
  // // -------------------------------------------------
  // Insert Concurrency matrix here and take away the 
  // following code which forces all the requests to be
  // dependent on previou requests
  //if (!log) {
  //  log = fopen("/home/kotla/mount.log","w");
  //	if (log == NULL) {
  //  exit(-1);
  //} 
  //}
  //fprintf(log," In parallelizer.insert :  cid : %d seq no : %qu eq op : %d fhandle : %d\n",
  //    req->cid,req->req_num,req->op,req->fhandle); 
   
  //fprintf(stderr," In parallelizer.insert :  cid : %d seq no : %qu eq op : %d fhandle : %d\n",
  //  req->cid,req->req_num,req->op,req->fhandle);
   
  for (iter=li->rbegin(); iter!=li->rend();iter++) {
    Req* cur = *iter;
    // fprintf(stderr,
    //    "other cid : %d seq no : %qu req op : %d fhandle : %d \n", 
    //    cur->cid,cur->req_num,cur->op,cur->fhandle);
    if (((req->cid == cur->cid) && !same_client_dependency) || is_dependent(req,cur)) {
      // fprintf(stderr, "Checking dependency my cid : %d seq no : %qu req op : %d fhandle : %d \n",
      // 		req->cid,req->req_num,req->op,req->fhandle);
      // 	fprintf(stderr,
      // 		"other cid : %d seq no : %qu req op : %d fhandle : %d \n", 
      // 		cur->cid,cur->req_num,cur->op,cur->fhandle);
      //fprintf(stderr," ------Dependency of my seq no : %qu cid : %d  op : %d on seq no : %qu client id : %d op : %d . \n", req->req_num,req->cid,req->op,cur->req_num,cur->cid,cur->op);
      req->dlist.push_back(cur);
      // Break as the requests are committed and 
      // inserted in sequential order
      // Update the olist of cur
      req->state = blocked;
      cur->olist.push_back(req);
	
      if (req->cid == cur->cid) {
	same_client_dependency = true;
      }
    }
    else {
      //fprintf(stderr,"Independent requests my seq no : %qu my cid : %d op : %d other seq no : %qu client id : %d op : %d. \n",req->req_num,req->cid,req->op,cur->req_num,cur->cid,cur->op);
    }
  }
  //}
  //else {
  //printf("Read only request \n");
  //}
  //#endif

  try {
    li->push_back(req);
  }
  catch (InsertFullQueue e) {
    e.what();
    mutex->unlock();
    return false;
  }  

  mutex->unlock();

  //printf(" Successfully inserted \n");
  // Signal the blocking worker threads to check if there is a ready request
  //pthread_mutex_lock(&req_queue_mutex);
  // Kotla : For now don't lock before signalling 
  //if (req->state == ready) {
  pthread_cond_signal(&req_ready_cond);
  //}
  //printf(" Signalling req is ready \n");
  //pthread_mutex_unlock(&req_queue_mutex);
  //printf("Unlocked the req_queue_mutex \n");
  return true;
}

Req * Parallelizer::next_request() {
  return (req_queue.next_request());
}

bool Parallelizer::remove(Req *req) {
  try{
    req_queue.remove(req);
  }
  catch(ReadEmptyQueue e) {
    e.what();
    return false;
  }
  delete(req); // Shouldn't the callee delete this 
  return true;
}

void Parallelizer::sync(Seqno chkpt) {
  next_chkpt = chkpt;
  req_queue.set_chkpt(chkpt);
}

void Parallelizer::clear(Seqno chkpt) {
  sync(chkpt);
  req_queue.clear();
}

void Parallelizer::register_read_state(int (*r)(Byz_req , int *, int *)) {
  read_state = r;
}

bool Parallelizer::is_dependent(Req *this_req, Req *other_req) {
  //fprintf(stderr,"This req op : %d handle : %d other Op : %d handle : %d \n",
  //  this_req->op, this_req->fhandle,other_req->op,other_req->fhandle);
  //fprintf(stderr,"Is dependent : %d ",
  //  !!conc_matrix[this_req->op][other_req->op][this_req->fhandle == other_req->fhandle]);

  // Kotla : Temporarily make everything dependent
  return !conc_matrix[this_req->op][other_req->op][this_req->fhandle == other_req->fhandle];
  //return false;
}

// Kotla :
// Lookup
int Parallelizer::conc_matrix[18][18][2] = 
  { 
   //  0     1     2     3     4     5     6     7     8     9    10    11    12    13    14    15    16    17
   // NFS 0 : NULL
   { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
   //  NFS 1 : get attr
   { {1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,1}},
   //  NFS 2 : set attr
   { {1,1},{1,0},{1,0},{1,1},{0,0},{1,0},{1,0},{1,1},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1}},
   // NFS 3 : Root
   { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
   // NFS 4 : Lookup file
   { {1,1},{1,1},{0,0},{1,1},{1,1},{0,0},{0,0},{1,1},{0,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1}},
   //{ {1,1},{1,1},{0,0},{1,1},{1,1},{0,0},{1,0},{1,1},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1}},
   // NFS 5 : Read sym link  
   { {1,1},{1,1},{1,0},{1,0},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{1,1}},
   // NFS 6 : Read file
   { {1,1},{1,1},{1,0},{1,1},{0,0},{1,1},{1,0},{1,1},{1,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{1,1}},
   // NFS 7 : Cache
   { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
   // NFS 8 : Write
   { {1,1},{1,0},{1,0},{1,1},{0,0},{1,0},{1,0},{1,1},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{0,0}},
   // NFS 9 : Create file
   { {1,1},{1,0},{1,0},{1,1},{1,0},{1,1},{1,0},{1,1},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{0,0}},
   // NFS 10 : Remove file
   { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
   // NFS 11 : Rename file
   { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
   // NFS 12 : Create file
   { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
   // NFS 13 : Create Sym link
   { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
   // NFS 14 : Create Dir
   { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
   // NFS 15 : Remove Dir
   { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{0,0},{0,0}},
   // NFS 16 : Read Dir
   { {1,1},{1,0},{1,0},{1,1},{0,0},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,1}},
   // NFS 17 : File Sys attr
   { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{1,1}}
  };


// Conservative concurrency matrix
// int Parallelizer::conc_matrix[18][18][2] = 
//   { 
//    //  0     1     2     3     4     5     6     7     8     9    10    11    12    13    14    15    16    17
//    // NFS 0 : NULL
//    { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
//    //  NFS 1 : get attr
//    { {1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,1}},
//    //  NFS 2 : set attr
//    { {1,1},{1,0},{1,0},{1,1},{0,0},{1,1},{1,0},{1,1},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1}},
//    // NFS 3 : Root
//    { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
//    // NFS 4 : Lookup file
//    { {1,1},{1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1}},
//    // NFS 5 : Read sym link  
//    { {1,1},{1,1},{1,0},{1,1},{1,1},{1,0},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{1,1}},
//    // NFS 6 : Read file
//    { {1,1},{1,1},{1,0},{1,1},{0,0},{1,1},{1,1},{1,1},{1,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{1,1}},
//    // NFS 7 : Cache
//    { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1}},
//    // NFS 8 : Write
//    { {1,1},{1,0},{1,0},{1,1},{0,0},{1,0},{1,0},{1,1},{1,0},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{0,0}},
//    // NFS 9 : Create file
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{1,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{0,0}},
//    // NFS 10 : Remove file
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
//    // NFS 11 : Rename file
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
//    // NFS 12 : Create file
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
//    // NFS 13 : Create Sym link
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
//    // NFS 14 : Create Dir
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
//    // NFS 15 : Remove Dir
//    { {1,1},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
//    // NFS 16 : Read Dir
//    { {1,1},{1,0},{1,0},{1,1},{0,0},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,0},{1,1}},
//    // NFS 17 : File Sys attr
//    { {1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{1,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{1,1},{1,1}}
//   }
