#ifndef _REQ_h
#define _REQ_h 1

#include "SharedList.h"
#include "th_assert.h"
//#include "arg.h"
#include "types.h"

// Request class has all the information about the request
// including the dependencies of this request.
typedef struct _thread_arg Thread_arg;
class RequestQueue;


class Req{
  //private :
  // Kotla : After debugging change the state to private
 public:
  ExecState state;  // running=2,ready=1 blocked=0
  int cid; // Client id of the request
  Request_id rid; // Request id assigned by the client
  Seqno req_num; // Seq num of the request assigned by the primary
  
  Thread_arg *req_state; // request state

  // nfs state
  int op;         // NFS operation 
  int fhandle;    // fhandle
  
  // List of requests that this request is dependent on
  SharedList<Req*> dlist; 

  // List of requests that are dependent on this request
  SharedList<Req*> olist;
  friend class RequestQueue;

  //public :
  Req(ExecState st, int& client, Request_id& id, Seqno& num, Thread_arg *&th_state) {
    state = st; cid = client, rid = id, req_num = num, req_state = th_state;
    op = 0; fhandle = 0;
  }

  ~Req() { }

  // This request is dependent on req. Add the request to dlist.
  void add_dependency(Req *req) {
    dlist.push_back(req);
  }

  // req is dependent on this request. Add the req to olist.
  void add_dependent(Req *req) {
    olist.push_back(req);
  }
  
  // Remove request from dlist
  void remove_dlist(Req *req) {
    dlist.remove(req);
  }

  Thread_arg* get_state() {
    return req_state;
  }

  // Set service specific state
  void set_state(int optype, int handle) {
    op = optype;
    fhandle = handle;    
  }
        
  // Returns true if the request is ready.
  bool update_dependency(Req *req) {
    // Check if the dlist is empty
    th_assert(dlist.size() > 0,"Trying to update a empty dlist");    
    dlist.remove(req);
    return (dlist.size() == 0 );
  }    
};

#endif // _REQ_H
