#ifndef _ARG_H
#define _ARG_H 1

#include "libbyz.h"
#include "Req.h"

typedef struct _thread_arg {
  int tid;           // thread id (deprecated)
  Byz_req inb;       // Request buffer
  Byz_rep outb;      // reply buffer
  Byz_buffer non_det;// non-det set by the primary like (mtime,ctime for nfs)
  int client;        // Client
  int ro;            // ro : Read only request
  int res;           // Status of the execution of the request 
  Request_id req_id; // Request id(timestamp) of the request  assigned by the client
  Rep_info *rep;     // Global info of the replies 
  int my_id;         // my id
  int rep_id;        // Replier id
  int view;          // view in which this request was received
  Seqno seqno;       // Seq no. of the request
  Req *req;          // Dependency information of this request
} Thread_arg;

typedef struct _thread_fattr{
  timeval cur_time;      
  int last_inum;
  int last_inum_from;
  int last_inum_to;
  int inum_clobbered;
  int prev_fid;
} Thread_fattr;


#endif // ARG_H
