#ifndef _fhe_proxy_h
#define _fhe_proxy_h

#include <map>
#include <vector>
#include <assert.h>

#include <NTL/ZZ.h>

#include "FHE/Ciphertext.h"
#include "FHE/FHEContext.h"
#include "FHE/FHE-SI.h"

#include "Polynomial.h"

using namespace std;
using namespace NTL;

class FHEProxy {
  private:
    map<unsigned int, Polynomial<Ciphertext>> invIndex;
    map<unsigned int, vector<Polynomial<Ciphertext>>> modReductionTable;

    FHEcontext &context;
    FHESISecKey &secretKey;
    FHESIPubKey &publicKey;
    KeySwitchSI *keySwitch;
    
    void GenerateRandPoly(Polynomial<ZZ_pX> &randPoly, unsigned int degree) const;
    void ApplyModularReduction(Polynomial<Ciphertext> &result,
                               const Polynomial<Ciphertext> &poly, unsigned int tag);
  public:
    FHEProxy(FHEcontext &context, FHESISecKey &secretKey, FHESIPubKey &publicKey, KeySwitchSI *keySwitch) : 
      context(context), secretKey(secretKey), publicKey(publicKey), keySwitch(keySwitch) { }
    void PerformQuery(Polynomial<Ciphertext> &poly, 
                      const vector<unsigned int> &queries,
                      bool modularReduction = false);
    void SetIndex(const map<unsigned int, Polynomial<Ciphertext>> &newIndex);
    void SetModReductionTable(const map<unsigned int, vector<Polynomial<Ciphertext>>> &newTable);
};

#endif