#ifndef _polynomial_h_
#define _polynomial_h_

template<class T>
class Polynomial {
  private:
    vector<T> coeffs;
  public:
    Polynomial() { }
  
    Polynomial(size_t degree) {
      coeffs.resize(degree + 1);
    }
  
    size_t GetDegree() const {
      return coeffs.size()-1;
    }
    
    void SetDegree(int degree, const T &val = T()) {
      coeffs.resize(degree+1, val);
    }
    
    Polynomial<T> &operator+=(const Polynomial<T> &other) {
      size_t i = 0;
      for (; i < coeffs.size() && i < other.coeffs.size(); i++) {
        coeffs[i] += other.coeffs[i];
      }
      for (; i < other.coeffs.size(); i++) {
        coeffs.push_back(other.coeffs[i]);
      }
      
      return *this;
    }
    
    template<class TT>
    Polynomial<T> &operator*=(const TT &value) {
      for (size_t i = 0; i < coeffs.size(); i++) {
        coeffs[i] *= value;
      }
      
      return *this;
    }
    
    template<class TT>
    Polynomial<T> &operator*=(const Polynomial<TT> &other) {
      const vector<TT> otherCoeffs = other.GetCoeffs();
      vector<T> newCoeffs;
      for (size_t i = 0; i < coeffs.size(); i++) {
        for (size_t j = 0; j < otherCoeffs.size(); j++) {
          T c = coeffs[i];
          c *= otherCoeffs[j];
          
          if (i+j >= newCoeffs.size()) {
            newCoeffs.push_back(c);
          } else {
            newCoeffs[i+j] += c;
          }
        }
      }
      
      swap(newCoeffs, coeffs);
      return *this;
    }
    
    Polynomial<T> &operator=(const Polynomial<T> &other) {
      coeffs = other.coeffs;
      return *this;
    }
    
    T &operator[](unsigned int ind) {
      return coeffs[ind];
    }
    
    const T &operator[](unsigned int ind) const {
      return coeffs[ind];
    }
    
    const vector<T> &GetCoeffs() const {
      return coeffs;
    }
    
    friend ostream &operator<<(ostream &os, const Polynomial<T> &other) {
      for (size_t i = 0; i < other.coeffs.size(); i++) {
        os << other[i] << ", ";
      }
      return os;
    }
};

#endif