# Pads a message (assuming UTF-8 encoding) using the TLS 1.0 padding scheme
# (assumes 128-bit blocks)
def pad_message(m):
  bytes_needed = 16 - (len(m) % 16)
  if bytes_needed == 0:
    bytes_needed = 16
  return m + bytes([bytes_needed - 1]*bytes_needed)

# Checks that the input is a message with a valid padding structure. If so, it
# returns the unpadded message, and otherwise, it returns None
def strip_padding(padded_msg):
  if len(padded_msg) == 0 or len(padded_msg) % 16 != 0:
    return None

  N = padded_msg[-1]
  if N < 0 or N > 15:
    return None

  (m, pad) = padded_msg[:-N-1], padded_msg[-N-1:]

  return m if all(v == N for v in pad) else None
