; filename:   fib.asm
; designer:   Steve Keckler
; date:	      October 22, 2003
; 
; This program computes and prints the 10th fibonacci number.  It
; requires no keyboard inputs and produces the following output:

; ---------------------------------------------------------------
; Chronologic VCS simulator copyright 1991-2002
; Contains Synopsys proprietary information.
; Compiler version 6.2; Runtime version 6.2;  Oct 23 15:44 2003
; 
; Running program: =   fib.vhex
; Computing fibonacci number: 5
; The result is: 8
; 
; ----- Halting the processor -----
;   PC  :  fd7a
;   nzp :  100
;   reg 0: 0000
;   reg 1: fffe
;   reg 2: 0030
;   reg 3: xxxx
;   reg 4: xxxx
;   reg 5: xxxx
;   reg 6: 9000
;   reg 7: fd75
; Completed        5675 cycles
; ---------------------------------------------------------------
    
.ORIG $3000

MAIN:
  LD R6, STACK_START  ; set up stack
                      ; assume main has activation record of size 3
		      ;   ret_value: R6+3; ret_addr: R6+4: dyn_link: R6+5
  STR R6, R6, #5      ; save main's stack pointer
  AND R0, R0, #0
  ADD R1, R0, #5      ; initialize operand for first call to fibonacci
		      ;   note - only works if output is single digit

  LEA R0, Top_string
  PUTS
  LD R2, ASCII_ZERO
  ADD R0, R1, R2
  PUTC
  LD R0, LineFeed
  PUTC

  ADD R0, R1, #0      ; put operand into arg register
  STR R0, R6, #6      ; save operand onto stack
  ADD R6, R6, #3      ; set R6 to activation record of callee
  JSR FIBONACCI

  LDR R1, R6, #3      ; retrieve return value from callee's activation record
  LEA R0, RESULT_STRING
  PUTS

  LD R2, ASCII_ZERO
  ADD R0, R1, R2
  PUTC

  LD R0, LineFeed
  PUTC
  HALT

STACK_START .FILL $9000
ASCII_ZERO .FILL $0030
Top_string .stringz "Computing fibonacci number: "
RESULT_STRING .stringz "The result is: "
LineFeed .stringz "\n"

FIBONACCI:
  STR R7, R6, #1      ; save return address
  STR R0, R6, #5      ; save R0
  STR R1, R6, #6      ; save R0
  LDR R0, R6, #3      ; load parameter n
  BRZ FIB_END         ; base cases (n=0 or n=1)
  ADD R0, R0, #-1
  BRZ FIB_END

  LDR R0, R6, #3      ; load parameter n
  ADD R0, R0, #-1     ; compute n-1
  STR R0, R6, #10     ; store n-1 as argument to next call
  STR R6, R6, #9      ; store dynamic link
  ADD R6, R6, #7      ; set SP to new activation record
  JSR FIBONACCI

  LDR R0, R6, #7      ; retrieve return value
  STR R0, R6, #4      ; save temporary on stack
  LDR R0, R6, #3      ; load parameter n
  ADD R0, R0, #-2     ; compute n-2
  STR R0, R6, #10      ; store n-2 as argument to next call
  STR R6, R6, #9      ; store dynamic link
  ADD R6, R6, #7      ; set SP to new activation record
  JSR FIBONACCI

  LDR R0, R6, #4      ; retrieve saved value (n-1)
  LDR R1, R6, #7      ; retrieve return value (n-2)
  ADD R0, R0, R1
  STR R0, R6, #0      ; save return value

  LDR R0, R6, #5      ; restore R0
  LDR R1, R6, #6      ; restore R1
  LDR R7, R6, #1      ; restore R7
  LDR R6, R6, #2      ; restore dynamic link
  RET

FIB_END:
  AND R0, R0, #0
  ADD R0, R0, #1
  STR R0, R6, #0      ; save return value
  LDR R0, R6, #5      ; restore R0
  LDR R1, R6, #6      ; restore R1
  LDR R7, R6, #1      ; restore R7
  LDR R6, R6, #2      ; restore dynamic link
  RET

.END
