//                              -*- Mode: Verilog -*-
// Filename        : barrel_shifter.v
// Description     : barrel shifter
// Author          : Stephen W. Keckler
// Created On      : Mon Oct 16 16:48:30 2006
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!

module barrel_shifter (instr, op1, sign, mag, result);
   input [3:0] instr;
   input [15:0] op1;
   input 	sign;
   input [3:0] 	mag;
   output [15:0] result;
   
   wire [3:0] 	 new_mag;
   wire 	 top_shift_bit;
   reg [15:0] 	 left_shift_st1, left_shift_st2;
   reg [15:0] 	 right_shift_st1, right_shift_st2;
   
   assign 	 new_mag = sign ? (~mag + 1'b1) : mag;
   assign	 top_shift_bit = (instr == `ASH) ? op1[15] : 1'b0;
   
   // shift left stage 1
   always @(op1 or new_mag)
     begin
	case(new_mag[3:2])
	  2'b00 : left_shift_st1 = op1;
	  2'b01 : left_shift_st1 = {op1[11:0], 4'b0};
	  2'b10 : left_shift_st1 = {op1[7:0], 8'b0};
	  2'b11 : left_shift_st1 = {op1[3:0], 12'b0};
	endcase // case(new_mag[3:2])
     end

   // shift left stage 2
   always @(left_shift_st1 or new_mag)
     begin
	case(new_mag[1:0])
	  2'b00 : left_shift_st2 = left_shift_st1;
	  2'b01 : left_shift_st2 = {left_shift_st1[14:0], 1'b0};
	  2'b10 : left_shift_st2 = {left_shift_st1[13:0], 2'b0};
	  2'b11 : left_shift_st2 = {left_shift_st1[12:0], 3'b0};
	endcase // case(new_mag[1:0])
     end

   // shift right stage 1

   always @(op1 or new_mag or top_shift_bit)
     begin
	case(new_mag[3:2])
	  2'b00 : right_shift_st1 = op1;
	  2'b01 : right_shift_st1 = {{4{top_shift_bit}}, op1[15:4]};
	  2'b10 : right_shift_st1 = {{8{top_shift_bit}}, op1[15:8]};
	  2'b11 : right_shift_st1 = {{12{top_shift_bit}}, op1[15:12]};
	endcase // case(new_mag[3:2])
     end

   // shift right stage 2
   always @(right_shift_st1 or new_mag or top_shift_bit)
     begin
	case(new_mag[1:0])
	  2'b00 : right_shift_st2 = right_shift_st1;
	  2'b01 : right_shift_st2 = {{1{top_shift_bit}}, right_shift_st1[15:1]};
	  2'b10 : right_shift_st2 = {{2{top_shift_bit}}, right_shift_st1[15:2]};
	  2'b11 : right_shift_st2 = {{3{top_shift_bit}}, right_shift_st1[15:3]};
	endcase // case(new_mag[3:2])
     end

  // combine
   assign
     result = sign ? right_shift_st2 : left_shift_st2;

endmodule


