//                              -*- Mode: Verilog -*-
// Filename        : datapath.v
// Description     : LC3.5 datapath
// Author          : Stephen W. Keckler
// Created On      : Sun Oct 12 16:36:39 2003
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!

`include "lc35.h"

/* -------------------------------------------------------------
 datapath
   Unpipelined datapath modele for LC3.5
 --------------------------------------------------------------- */

module datapath(clk, reset_pc,
		pc_ld, w_newpc, 
		ir_ld, 
		sr_sel, rr_ld,
		link_reg, w_regfile_write, 
		op1_mux, op2_mux, x_ld,
		m_ld, m_sel, m_write,
		ir_opcode, ir_imm, ir_jsr, ir_nzp, dp_nzp);
   
   input clk, reset_pc;
   input pc_ld, w_newpc;
   input ir_ld;
   
   input sr_sel, rr_ld;
   input link_reg, w_regfile_write;
   input op1_mux;
   input [2:0] op2_mux;
   
   input       x_ld;
   input       m_ld, m_sel;
   input       m_write;
   
   output [3:0] ir_opcode;
   output 	ir_imm, ir_jsr;
   output [2:0] ir_nzp, dp_nzp;
   
   
   // fetch
   wire [15:0] 	pc_out, pc_plus1, ir_in, ir_out;
   reg [15:0] 	pc_in;
   
   // read
   wire [15:0] 	rr_regA_in, rr_regB_in, regA_out, regB_out;
   
   // execute
   
   wire [15:0] 	alu_op1;
   reg [15:0] 	alu_op2;
   wire [15:0] 	xreg_in, x_data;
   
   // memory
   wire [15:0] 	m_data_out, mreg_in, mreg_out;
   
   // write
   wire [15:0] 	w_data;
   wire [2:0] 	wreg_sel, regB_sel;
   
   
   
   // Fetch stage
   
   assign 	pc_plus1 = pc_out + 1;
   
   always @(reset_pc or w_newpc or mreg_out or pc_plus1)
     begin
	if(reset_pc) pc_in = `RESET_PC;
	else if (w_newpc) pc_in = mreg_out;
	else pc_in = pc_plus1;
     end
  
   dff_ld #16 pc_reg(clk, pc_ld, pc_in, pc_out);
	
   memory id_memory(clk, pc_out, x_data, m_write, ir_in, regB_out, m_data_out);
   dff_ld #16 ir_reg(clk, ir_ld, ir_in, ir_out);
   
   assign ir_opcode = ir_in[15:12];
   assign ir_imm = ir_in[5];
   assign ir_jsr = ir_in[11];
   assign ir_nzp = ir_in[11:9];
   
   // Register read stage
   
   assign regB_sel = sr_sel ? ir_out[11:9] : ir_out[2:0];
   assign wreg_sel = link_reg ? 3'b111 : ir_out[11:9];
   
   regfile regfile1(clk, ir_out[8:6], regB_sel, wreg_sel,
		    w_regfile_write, w_data, rr_regA_in, rr_regB_in);
   dff_ld #16 rr_regA(clk, rr_ld, rr_regA_in, regA_out);
   dff_ld #16 rr_regB(clk, rr_ld, rr_regB_in, regB_out);
   
   // Execute stage
   
   assign
	 alu_op1 = (op1_mux == `OP1_SELECT_PC) ? pc_plus1 : regA_out;

   always @(op2_mux or ir_out or regB_out)
     case(op2_mux)
       `OP2_SELECT_imm5: alu_op2 = {{11{ir_out[4]}}, ir_out[4:0]};
       `OP2_SELECT_offset6: alu_op2 = {{10{ir_out[5]}}, ir_out[5:0]};
       `OP2_SELECT_offset9: alu_op2 = {{7{ir_out[8]}}, ir_out[8:0]};
       `OP2_SELECT_offset11: alu_op2 = {{5{ir_out[10]}}, ir_out[10:0]};
       default: alu_op2 = regB_out;
     endcase // case(op2_mux)
   
   alu alu1(ir_opcode, alu_op1, alu_op2, xreg_in);
   dff_ld #16 xreg(clk, x_ld, xreg_in, x_data);
   
   // Memory stage - memory instantiated in fetch stage
   
   dff_ld #16 m_reg(clk, m_ld, mreg_in, mreg_out);
   
   assign
         mreg_in = m_sel ? m_data_out : x_data;
      
   // Write-back stage
   
   assign w_data = link_reg ? pc_plus1 : mreg_out;
   assign dp_nzp[2] = mreg_out[15];
   assign dp_nzp[1] = ~(|mreg_out[15:0]);
   assign dp_nzp[0] = ~dp_nzp[2] & ~dp_nzp[1];
   
endmodule