//                              -*- Mode: Verilog -*-
// Filename        : lc35.h
// Description     : LC35 header file
// Author          : Stephen W. Keckler
// Created On      : Mon Oct 20 17:18:55 2003
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!

// timescale

`timescale 1ns/10ps
`define tFF 2

// instruction encodings

`define ADD 4'h1
`define SUB 4'h8
`define AND 4'h5
`define OR  4'hd
`define ASH 4'ha
`define LSH 4'hb
`define NOT 4'h9
`define LEA 4'he
`define LD  4'h2
`define LDR 4'h6
`define ST  4'h3
`define STR 4'h7
`define BR  4'h0
`define JMP 4'hc
`define JSR 4'h4
`define TRAP 4'hf

// Initial PC value after reset
`define RESET_PC 16'h3000

// LC3.5 state machine encodings
`define RESET  3'h0
`define FETCH  3'h1
`define RREAD  3'h2
`define EXEC   3'h3
`define MEMORY 3'h4
`define WRITE  3'h5


// Operand MUX #1 encodings

`define OP1_SELECT_PC 1'b1
`define OP1_SELECT_REG 1'b0

// Operand MUX #2 encodings

`define OP2_SELECT_imm5     3'h0
`define OP2_SELECT_offset6  3'h1
`define OP2_SELECT_offset9  3'h2
`define OP2_SELECT_offset11 3'h3
`define OP2_SELECT_REG      3'h4

