//                              -*- Mode: Verilog -*-
// Filename        : memory.v
// Description     : dual ported memory array
// Author          : Stephen W. Keckler
// Created On      : Sun Oct 12 16:09:57 2003
// Last Modified By: .
// Last Modified On: .
// Update Count    : 0
// Status          : Unknown, Use with caution!

`include "lc35.h"

/* -------------------------------------------------------------
 memory array
   This is a very behavioral block and cannot be synthesized into
   primitive logic circuits.  These would typically be included as
   "black-box" macros in an ASIC (application specific integrated 
   circuit design). They are often created using memory generators
 --------------------------------------------------------------- */
/* Old definitions - no longer in use
`define KBSR 16'hf400
`define KBDR 16'hf401
`define DSR 16'hf3fc
`define DDR 16'hf3ff
`define MCR 16'hffff
 */

`define KBSR 16'hfe00
`define KBDR 16'hfe02
`define DSR 16'hfe04
`define DDR 16'hfe06
`define MCR 16'hfffe


module memory(clk, iaddr, daddr, write, instr, data_in, data_out);
   input  clk, write;
   input  [15:0] iaddr, daddr;
   input [15:0]  data_in;
   output [15:0] instr, data_out;

   reg [15:0] 	 mem_array[0:65535];
   reg [15:0] 	 data_out;
   
   // special registers to handle start/stop
   reg [15:0]	 mcr;
   reg [15:0] 	 kbdr, ddr;
   reg [15:0]	 kbsr, dsr;

   // writes to array - behaves like clocked element, but no write/read bypassing
   always @(posedge clk)
     begin
	if(write) begin
	   case(daddr)
	     `DDR: 
	       begin
		  ddr = data_in;
		  $lc35_putc(data_in);
	       end
	     `DSR: ;
	     `KBSR: ;
	     `KBDR: ;
             `MCR: mcr <= #`tFF data_in;
	     default: mem_array[daddr] <= #`tFF data_in;
	   endcase
	end // if (write)
     end // always @ (posedge clk)
   

   // read instruction from memory
   
   assign
     instr = mem_array[iaddr];
   

   // read data from memory
   always @(daddr or ddr or kbdr or write or mcr)
     begin
	case(daddr)
	  `DDR: data_out = ddr;
	  `DSR: data_out = 16'h8000;
	  `KBSR:
	    begin
	       kbdr = $lc35_getc();
	       data_out = 16'h8000;
	    end
	  `KBDR: data_out = kbdr;
	  `MCR: data_out = mcr;
	  default: data_out = mem_array[daddr];
	endcase // case(daddr)
     end // always @ (daddr)

endmodule
