(defun sum-to-n (n)
  (if (zp n)
      0
    (+ n (sum-to-n (- n 1)))))

; Fails:
(thm (implies (natp n)
              (equal (sum-to-n n)
                     (/ (* n (+ n 1))
                        2))))

; Include an arithmetic book:
(include-book "arithmetic/top" :dir :system)

; Succeeds:
(thm (implies (natp n)
              (equal (sum-to-n n)
                     (/ (* n (+ n 1))
                        2))))

; Fails:
(thm (implies (natp k)
              (equal (sum-to-n (* 2 k))
                     (* k (+ (* 2 k) 1)))))

; Create a rewrite rule:
(defthm sum-to-n-rewrite
  (implies (natp n)
           (equal (sum-to-n n)
                  (/ (* n (+ n 1))
                     2))))

; Now, succeeds immediately:
(thm (implies (natp k)
              (equal (sum-to-n (* 2 k))
                     (* k (+ (* 2 k) 1)))))
