(defun fib (n)
  (declare (type (integer 0 *) n))
  (if (zp n)
      0
    (if (eql n 1)
        1
      (+ (fib (- n 1))
         (fib (- n 2))))))

(time$ (fib 40))
(time$ (fib 40))

; Fun fact: (fib n) makes (fib (+ 1 n)) calls:

(defun fib-calls (n)
  (declare (type (integer 0 *) n))
  (if (zp n)
      1
    (if (eql n 1)
        1
      (+ (fib-calls (- n 1))
         (fib-calls (- n 2))))))

(thm (implies (natp n)
              (equal (fib-calls n)
                     (fib (+ 1 n)))))

(time$ (fib 41))

; So on my 5-year-old Macbook Pro, (fib 40) made 165,580,141 calls in
; less than 2 seconds -- not too shabby.

; But we can do much better!

(memoize 'fib)
(time$ (fib 40))
(time$ (fib 10000))
