(defun sortedp (lst)
  (if (or (endp lst)
          (endp (cdr lst)))
      t
    (and (<= (first lst)
             (second lst))
         (sortedp (cdr lst)))))

(defun insert (n lst)
  (if (endp lst)
      (list n)
    (if (< n (car lst))
        (cons n lst)
      (cons (car lst)
            (insert n (cdr lst))))))

(defun insertion-sort (lst)
  (if (endp lst)
      nil
    (insert (car lst)
            (insertion-sort (cdr lst)))))

(thm (sortedp (insertion-sort lst)))
