(defun rev (x) ; Append (built-in) does list concatenation (like app, earlier)
  (if (consp x)
      (append (rev (cdr x))
              (list (car x)))
    nil))

(thm ; Recall that this was proved automatically.
 (implies (true-listp x)
          (equal (rev (rev x))
                 x)))

(thm ; fails if we avoid sub-inductions
 (implies (true-listp x)
          (equal (rev (rev x))
                 x))
 :hints (("Goal"
          :induct t            ; use induction immediately
          :do-not-induct t     ; do not use any additional inductions
          )))

#||
 *** Key checkpoint under a top-level induction ***

 Subgoal *1/1''
 (IMPLIES (AND (CONSP X)
               (EQUAL (REV (REV (CDR X))) (CDR X))
               (TRUE-LISTP (CDR X)))
          (EQUAL (REV (APPEND (REV (CDR X)) (LIST (CAR X))))
                 X))
||#

(defthm rev-append ; useful lemma, constructed by looking at checkpoint
  (equal (rev (append x y))
         (append (rev y) (rev x))))

(thm ; now, succeeds:
 (implies (true-listp x)
          (equal (rev (rev x))
                 x))
 :hints (("Goal" :induct t :do-not-induct t)))
