; Alternate solution to....
; Challenge: Define rotate for a list and prove that if you rotate n steps,
; where n is its length, then you get the list back.

; (Yet another approach, left as an exercise: "pick-a-point" strategy to reduce
; to proving a lemma about (nth i (rotate n x)) for i <= n.)

(defun rotate (n x)
  (if (zp n)
      x
    (rotate (1- n)
            (append (cdr x)
                    (list (car x))))))

(defun firstn (i x)
  (if (zp i)
      nil
    (cons (car x)
          (firstn (1- i) (cdr x)))))

(defun dropn (i x) ; really, built-in function nthcdr
  (if (zp i)
      x
    (dropn (1- i) (cdr x))))

; Proved in support of rotate-i (discovered by looking at a checkpoint).
(defthm len-append
  (equal (len (append x y))
         (+ (len x) (len y))))

(defthm dropn-append
  (implies (and (natp i)
                (<= i (len x)))
           (equal (dropn i (append x y))
                  (append (dropn i x) y))))

(defthm firstn-append
  (implies (and (natp i)
                (<= i (len x)))
           (equal (firstn i (append x y))
                  (firstn i x))))

(defthm append-assoc
  (equal (append (append x y) z)
         (append x y z)))

; Formulated in support of rotate-len (a special case where i = 0).
(defthm rotate-i
  (implies (and (true-listp x)
                (natp i)
                (<= i (len x)))
           (equal (rotate i x)
                  (append (dropn i x)
                          (firstn i x))))
  :hints (("Goal" :induct (rotate i x))))

(defthm dropn-len
  (implies (true-listp x)
           (equal (dropn (len x) x)
                  nil)))

(defthm rotate-len
  (implies (true-listp x)
           (equal (rotate (len x) x)
                  x)))
