(in-package "ACL2")

; See rotate.lsp for how this proof was developed.

(defun rotate (n x)
  (if (zp n)
      x
    (rotate (1- n)
            (append (cdr x)
                    (list (car x))))))

(defun rotate-append-induction (x y)
  (if (atom x)
      y
    (rotate-append-induction (cdr x)
                             (append y (list (car x))))))

(defthm append-assoc
  (equal (append (append x y) z)
         (append x y z)))

(defthm rotate-append
  (implies (and (true-listp x)
                (true-listp y))
           (equal (rotate (len x) (append x y))
                  (append y x)))
  :hints (("Goal" :induct (rotate-append-induction x y)))
  :rule-classes nil)

(defthm rotate-len
  (implies (true-listp x)
           (equal (rotate (len x) x)
                  x))
  :hints (("Goal" :use ((:instance rotate-append (y nil))))))

