(in-package "ACL2")

; Challenge: Define rotate for a list and prove that if you rotate n steps,
; where n is its length, then you get the list back.

(defun rotate (n x)
  (if (zp n)
      x
    (rotate (1- n)
            (append (cdr x)
                    (list (car x))))))

(local (include-book "rotate-proof"))

(defthm rotate-len
  (implies (true-listp x)
           (equal (rotate (len x) x)
                  x)))
