(in-package "SAT")

(include-book "farray")
(include-book "tools/mv-nth" :dir :system)

;; ========================== CREATE-FARRAY ==========================

(defun create-field-table (field-lengths offset pos st)
  (declare (xargs :guard (and (acl2::pos-listp field-lengths)
                              (integerp offset)
                              (<= 0 offset)
                              (< offset (mem-len st))
                              (integerp pos)
                              (<= 0 pos)
                              (< pos (mem-len st))
                              (sb60p (mem-len st)))
                  :stobjs (st)))
  (b* (;; ((if (not (mbt (and (pos-listp field-lengths)
       ;;                     (integerp offset)
       ;;                     (<= 0 offset)
       ;;                     (< offset (mem-len st))
       ;;                     (integerp pos)
       ;;                     (<= 0 pos)
       ;;                     (< pos (mem-len st))
       ;;                     (sb60p (mem-len st))))))
       ;;  st)
       ((if (atom field-lengths))
        (!memi pos offset st))
       (st (!memi pos offset st))
       ((if (or (<= (mem-len st) (+ offset (car field-lengths)))
                (<= (mem-len st) (1+ pos))))
        st)
       )
      (create-field-table (cdr field-lengths)
                          (+ offset (car field-lengths))
                          (1+ pos)
                          st)))

(defun sum-poss (x)
  (declare (xargs :guard (acl2::pos-listp x)))
  (if (atom x)
      0
    (+ (car x) (sum-poss (cdr x)))))

(defthm natp-sum-poss
  (implies (acl2::pos-listp x)
           (natp (sum-poss x)))
  :rule-classes :type-prescription)


(defthm mem-len-create-field-table
  (implies (and (acl2::pos-listp field-lengths)
                (integerp pos)
                (<= 0 pos)
                (< pos (mem-len st)))
           (equal (mem-len (create-field-table field-lengths offset pos st))
                  (mem-len st))))

(defun create-farray (field-lengths start st)
  (declare (xargs :guard (and (acl2::pos-listp field-lengths)
                              (integerp start)
                              (<= 0 start)
                              );(< start (mem-len st)))
                  :guard-debug t
                  :stobjs (st)))
  (b* (((if (not (sb60p (+ start
                           1
                           (len field-lengths)
                           1
                           (sum-poss field-lengths)
                           1))))
        st)
       (st (resize-mem (+ start
                          1
                          (len field-lengths)
                          1
                          (sum-poss field-lengths)
                          1)
                       st))
       (st (create-field-table field-lengths
                               (+ start 1 (len field-lengths) 1)
                               (1+ start)
                               st))
       (st (!memi start (len field-lengths) st)))
      st))
