(in-package "SAT")

;; ===================================================================
;; ============================ VARIABLES ============================

; Consider posp
(defun variablep (x)
  (declare (xargs :guard t))
  (and (integerp x)
       (< 0 x)))


;; ===================================================================
;; ============================ LITERALS =============================

(defun literalp (x)
  (declare (xargs :guard t))
  (and (integerp x)
       (not (equal x 0))))


(defthm literalp-implies-eqlablep
  (implies (literalp x)
           (eqlablep x)))


;; ===================================================================
;; ========================== LITERAL-LIST ===========================

(defun literal-listp (x)
  (declare (xargs :guard t))
  (if (atom x)
      (null x)
    (and (literalp (car x))
         (literal-listp (cdr x)))))


(defthm literal-listp-implies-eqlable-listp
  (implies (literal-listp x)
           (eqlable-listp x)))

(defthm literal-listp-implies-literalp-member
  (implies (and (literal-listp x)
                (member e x))
           (literalp e)))

(defthm literal-listp-append
  (implies (and (literal-listp x)
                (literal-listp y))
           (literal-listp (append x y))))


;; ===================================================================
;; ============================ NEGATION =============================

(defun negatedp (x)
  (declare (xargs :guard (literalp x)))
  (< x 0))

(defun negate (x)
  (declare (xargs :guard (literalp x)))
  (- x))


(defthm literalp-negate
  (equal (literalp (negate x))
         (literalp x)))

(defthm literalp-implies-not-equal-negate
  (implies (literalp x)
           (not (equal (negate x) x))))

(defthm negate-negate
  (implies (literalp x)
           (equal (negate (negate x))
                  x)))


;; ===================================================================
;; ======================= LITERAL-CONVERSION ========================

; No longer used to my knowledge.

;; (defun literal-to-variable (x)
;;   (declare (xargs :guard (literalp x)))
;;   (abs x))


;; (defthm variablep-literal-to-variable
;;   (equal (variablep (literal-to-variable x))
;;          (literalp x)))


;; ===================================================================
;; =========================== VAR-TO-NAT ============================

; No longer used to my knowledge.

;; (defun variable-to-natural (variable)
;;   (declare (xargs :guard (variablep variable)))
;;   variable)


;; (defthm natp-variable-to-natural
;;   (implies (variablep x)
;;            (natp (variable-to-natural x)))
;;   :rule-classes :type-prescription)

;; (defthm natp-+--1-variable-to-natural
;;   (implies (variablep x)
;;            (natp (+ -1 (variable-to-natural x)))))

;; (defthm variable-to-natural-not-0
;;   (implies (variablep x)
;;            (equal (equal (variable-to-natural x) 0)
;;                   nil)))

;; (defthm natp-variable-to-natural-literal-to-variable
;;   (implies (literalp x)
;;            (natp (variable-to-natural (literal-to-variable x)))))

;; ; yuck
;; (defthm natp-implies-rationalp
;;   (implies (natp x)
;;            (rationalp x)))


;; ===================================================================
;; ============================ DISABLES =============================

(in-theory (disable variablep
                    literalp
                    ;literal-listp
                    negatedp
                    negate
                    ;literal-to-variable
                    ;variable-to-natural
                    ;natp ; needed to prevent acl2 from going crazy
                    ))