#ifndef learnpnp_Exploit_h__guard
#define learnpnp_Exploit_h__guard

#include <algorithm>

#include <pnp/learning_plan/ExpPolicy.h>

namespace learnpnp {

/**
*\brief Implements an exploration strategy that always chooses the state with the highest value
*
*\author Matteo Leonetti
*/
class Exploit : public ExpPolicy {

public:

	/**
	 * \brief Creates the Exploit strategy, the use of memory is active by default.
	 *
	 * \see ExpPolicy about memory.
	 */
    Exploit(bool remember = true) : ExpPolicy(remember) {}
	
private:
	
	int makeChoice(Learner *learner,const Marking &current, const std::vector<Marking> &states);

};

}

#endif
