#include <pnp/learning_plan/exp/Exploit.h>

#include <boost/bind.hpp>
#include <iterator>

namespace learnpnp {

int Exploit::makeChoice(Learner *learner,const Marking &current, const std::vector<Marking> &states) {

    std::vector<double> values;
    std::transform(states.begin(),
                   states.end(),
                   std::back_inserter(values),
                   boost::bind(&Learner::valueOf,learner,_1));

    std::vector<double>::iterator elem = std::max_element(values.begin(), values.end());

    int c = std::count(values.begin(),values.end(),*elem);

    if (c > 1) {

        //choose randomly among the equal ones
        std::vector<int> maxElementsPos;

        for (int i=0, s = values.size(); i < s; ++i) {
            if (values[i] == *elem)
                maxElementsPos.push_back(i);
        }

        int chosen = ( rand() / ( RAND_MAX / maxElementsPos.size() ) );

        return maxElementsPos[chosen];

    }
    else
        return std::distance(values.begin(), elem);
}

}
