#include <pnp/learning_plan/exp/ExploitWithHysteresis.h>

#include <boost/bind.hpp>

#include <algorithm>
#include <cmath>

using namespace std;

namespace learnpnp {
	
std::map<std::string, ExploitWithHysteresis::MemoryType> ExploitWithHysteresis::memories;

ExploitWithHysteresis::ExploitWithHysteresis(const std::string& planName, double hysteresis, bool remember) :
				ExpPolicy( remember),
				oldMemory(&memories[planName]),
				hysteresis(hysteresis),
				planName(planName){}

int ExploitWithHysteresis::makeChoice(Learner* learner, const learnpnp::Marking& current, const std::vector< Marking >& states) {

	std::vector<double> values;
	std::transform(states.begin(),
				   states.end(),
				   std::back_inserter(values),
				   boost::bind(&Learner::valueOf,learner,_1));
				   
	std::vector<double>::iterator elem = std::max_element(values.begin(), values.end());

	int position = distance(values.begin(),elem);

	MemoryType::const_iterator  memorized = oldMemory->find(current);
	
	if(memorized != oldMemory->end() && states[position] != memorized->second) {

		//if I'm changing the policy, check whether it's higher than the hysteresis
		double old_value = learner->valueOf(memorized->second);
		
		if((*elem) <= old_value + hysteresis * abs(old_value)) {
			
			//use the old one if possible
			vector<Marking>::const_iterator found = find(states.begin(),states.end(),memorized->second);
			if(found != states.end())
				return distance(states.begin(),found);
		}
	}
	//in any other case (value higher than hysteresis or old one not among the admissible next markings

	(*oldMemory)[current]=states[position];
	
	return position;
	
}

void ExploitWithHysteresis::clearMemory() {
	memories.clear();
}

void ExploitWithHysteresis::forget(const std::string& planName) {
	memories[planName].clear();
}

ExpPolicy::MemoryType *ExploitWithHysteresis::getPolicy() {
  return oldMemory;
}


ExploitWithHysteresis::~ExploitWithHysteresis() {}

}

