/*
 * Decompiled with CFR 0.152.
 */
public class minesweeper {
    public int[][] mines;
    public int[][] tiles;
    private String status;
    private int numMines;
    private int foundMines;

    public minesweeper() {
        this.initGame(9, 9);
    }

    public minesweeper(int n, int n2) {
        this.initGame(n, n2);
    }

    public String getStatus() {
        return this.status;
    }

    public int getMines(int n, int n2) {
        if (this.validIndex(n, n2)) {
            return this.mines[n][n2];
        }
        return -1;
    }

    public int getTiles(int n, int n2) {
        if (this.validIndex(n, n2)) {
            return this.tiles[n][n2];
        }
        return -1;
    }

    public void markTile(int n, int n2, int n3) {
        if (this.validIndex(n, n2) && this.status.compareTo("play") == 0) {
            switch (n3) {
                case 0: {
                    if (this.tiles[n][n2] == 0 || this.tiles[n][n2] == 3) break;
                    this.tiles[n][n2] = 0;
                    if (this.gameWon()) {
                        this.status = "win";
                        break;
                    }
                    if (this.mines[n][n2] == 9) {
                        this.status = "lose";
                        break;
                    }
                    if (this.mines[n][n2] != 0) break;
                    this.markTile(n - 1, n2 - 1, 0);
                    this.markTile(n - 1, n2, 0);
                    this.markTile(n - 1, n2 + 1, 0);
                    this.markTile(n, n2 - 1, 0);
                    this.markTile(n, n2 + 1, 0);
                    this.markTile(n + 1, n2 - 1, 0);
                    this.markTile(n + 1, n2, 0);
                    this.markTile(n + 1, n2 + 1, 0);
                    break;
                }
                case 1: {
                    this.tiles[n][n2] = 1;
                    break;
                }
                case 2: {
                    this.tiles[n][n2] = 2;
                    break;
                }
                case 3: {
                    this.tiles[n][n2] = 3;
                    break;
                }
            }
        }
    }

    public String toStringMines() {
        String string = "\n";
        for (int i = 0; i < this.mines.length; ++i) {
            for (int j = 0; j < this.mines[i].length; ++j) {
                string = string + this.mines[i][j];
            }
            string = string + "\n";
        }
        return string;
    }

    public String toStringTiles() {
        String string = "";
        for (int i = 0; i < this.mines.length; ++i) {
            for (int j = 0; j < this.mines[i].length; ++j) {
                string = string + this.tiles[i][j];
            }
            string = string + "\n";
        }
        return string;
    }

    public String toStringBoard() {
        String string = "";
        for (int i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles[i].length; ++j) {
                string = string + this.getBoard(i, j);
            }
            string = string + "\n";
        }
        return string;
    }

    public char getBoard(int n, int n2) {
        int n3 = 32;
        switch (this.tiles[n][n2]) {
            case 0: {
                if (this.mines[n][n2] == 0) {
                    n3 = 32;
                    break;
                }
                n3 = (char)(this.mines[n][n2] + 48);
                break;
            }
            case 1: {
                n3 = 88;
                break;
            }
            case 2: {
                n3 = 63;
                break;
            }
            case 3: {
                n3 = 70;
                break;
            }
        }
        if (this.status.compareTo("play") != 0) {
            if (this.status.equals("win")) {
                if (this.mines[n][n2] == 9) {
                    n3 = 70;
                }
            } else if (this.mines[n][n2] == 9 && this.tiles[n][n2] == 0) {
                n3 = 33;
            } else if (this.mines[n][n2] == 9) {
                n3 = 42;
            } else if (this.mines[n][n2] != 9 && this.tiles[n][n2] == 3) {
                n3 = 45;
            }
        }
        return (char)n3;
    }

    private void initGame(int n, int n2) {
        if (n >= 1 && n2 >= 1) {
            this.mines = new int[n][n2];
            this.tiles = new int[n][n2];
            this.resetTiles();
            this.placeMines();
            this.calculateClues();
            this.status = "play";
        }
    }

    private void resetTiles() {
        for (int i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles[i].length; ++j) {
                this.tiles[i][j] = 1;
            }
        }
    }

    private void placeMines() {
        int n = this.mines.length;
        int n2 = this.mines[0].length;
        this.numMines = n * n2 / 10 + 1;
        if (this.numMines <= 0) {
            this.numMines = 1;
        }
        int n3 = 0;
        while (n3 < this.numMines) {
            int n4;
            int n5 = (int)(Math.random() * (double)n);
            if (this.mines[n5][n4 = (int)(Math.random() * (double)n2)] == 9) continue;
            this.mines[n5][n4] = 9;
            ++n3;
        }
    }

    private void calculateClues() {
        int[] nArray = new int[]{-1, -1, -1, 0, 0, 1, 1, 1};
        int[] nArray2 = new int[]{-1, 0, 1, -1, 1, -1, 0, 1};
        for (int i = 0; i < this.mines.length; ++i) {
            for (int j = 0; j < this.mines[i].length; ++j) {
                if (this.mines[i][j] != 9) continue;
                for (int k = 0; k < 8; ++k) {
                    if (!this.validIndex(i + nArray[k], j + nArray2[k]) || this.mines[i + nArray[k]][j + nArray2[k]] == 9) continue;
                    int[] nArray3 = this.mines[i + nArray[k]];
                    int n = j + nArray2[k];
                    nArray3[n] = nArray3[n] + 1;
                }
            }
        }
    }

    private boolean validIndex(int n, int n2) {
        boolean bl = false;
        if (n >= 0 && n < this.mines.length && n2 >= 0 && n2 < this.mines[0].length) {
            bl = true;
        }
        return bl;
    }

    private boolean gameWon() {
        boolean bl = true;
        for (int i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles[i].length; ++j) {
                if (this.tiles[i][j] == 0 || this.mines[i][j] == 9) continue;
                bl = false;
            }
        }
        return bl;
    }
}

