/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class minesweeperGUI
extends JFrame
implements MouseListener {
    minesweeper game;
    JPanel gamePanel;
    JPanel statusPanel;
    JLabel statusLabel;
    mineButton[][] mb;
    Color backGround;
    int numRows = 9;
    int numCols = 9;
    Icon mineIcon = new ImageIcon(this.getClass().getResource("mine.jpg"));
    Icon minexIcon = new ImageIcon(this.getClass().getResource("minex.jpg"));
    Icon mineredIcon = new ImageIcon(this.getClass().getResource("minered.jpg"));
    Icon flagIcon = new ImageIcon(this.getClass().getResource("flag.jpg"));

    public minesweeperGUI() {
        this.backGround = Color.WHITE;
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setMnemonic('N');
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                minesweeperGUI.this.newGame();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        jMenuItem2.setMnemonic('X');
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        jMenuBar.add(jMenu);
        this.gamePanel = new JPanel();
        this.gamePanel.setLayout(new GridLayout(this.numRows, this.numCols));
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new FlowLayout(1));
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(new Font("Serif", 1, 24));
        this.statusPanel.add(this.statusLabel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.statusPanel, "North");
        container.add((Component)this.gamePanel, "Center");
        this.gamePanel.addMouseListener(this);
        this.game = new minesweeper(this.numRows, this.numCols);
        this.mb = new mineButton[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.mb[i][j] = new mineButton(i, j);
                this.mb[i][j].addMouseListener(this);
                this.gamePanel.add(this.mb[i][j]);
            }
        }
        this.statusLabel.setText("New Game");
        this.setTitle("Minesweeper");
        this.setContentPane(container);
        this.setSize(400, 300);
        this.show();
    }

    private void newGame() {
        this.game = new minesweeper(this.numRows, this.numCols);
        this.updateGame();
        this.statusLabel.setText("New Game");
    }

    public void updateGame() {
        for (int i = 0; i < this.numRows; ++i) {
            block15: for (int j = 0; j < this.numCols; ++j) {
                switch (this.game.getBoard(i, j)) {
                    case '1': {
                        this.mb[i][j].setText("1");
                        this.mb[i][j].setForeground(Color.blue);
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(this.backGround);
                        continue block15;
                    }
                    case '2': {
                        this.mb[i][j].setText("2");
                        this.mb[i][j].setForeground(Color.green);
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(this.backGround);
                        continue block15;
                    }
                    case '3': {
                        this.mb[i][j].setText("3");
                        this.mb[i][j].setForeground(Color.red);
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(this.backGround);
                        continue block15;
                    }
                    case '4': {
                        this.mb[i][j].setText("4");
                        this.mb[i][j].setForeground(Color.orange);
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(this.backGround);
                        continue block15;
                    }
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': {
                        this.mb[i][j].setText(Integer.toString(this.game.getBoard(i, j)));
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(this.backGround);
                        continue block15;
                    }
                    case ' ': {
                        this.mb[i][j].setText("");
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(this.backGround);
                        continue block15;
                    }
                    case 'X': {
                        this.mb[i][j].setText("");
                        this.mb[i][j].setIcon(null);
                        this.mb[i][j].setBackground(null);
                        continue block15;
                    }
                    case '?': {
                        this.mb[i][j].setText("?");
                        this.mb[i][j].setForeground(Color.blue);
                        this.mb[i][j].setIcon(null);
                        continue block15;
                    }
                    case 'F': {
                        this.mb[i][j].setText("");
                        this.mb[i][j].setIcon(this.flagIcon);
                        continue block15;
                    }
                    case '*': {
                        this.mb[i][j].setText("");
                        this.mb[i][j].setBackground(this.backGround);
                        this.mb[i][j].setIcon(this.mineIcon);
                        continue block15;
                    }
                    case '-': {
                        this.mb[i][j].setText("");
                        this.mb[i][j].setBackground(this.backGround);
                        this.mb[i][j].setIcon(this.minexIcon);
                        continue block15;
                    }
                    case '!': {
                        this.mb[i][j].setText("");
                        this.mb[i][j].setBackground(this.backGround);
                        this.mb[i][j].setIcon(this.mineredIcon);
                    }
                }
            }
        }
        this.statusLabel.setText(this.game.getStatus());
        if (this.game.getStatus().equalsIgnoreCase("play")) {
            this.statusLabel.setForeground(Color.black);
            this.statusLabel.setText("Game in Progress ...");
        } else if (this.game.getStatus().equalsIgnoreCase("win")) {
            this.statusLabel.setForeground(new Color(10, 104, 17));
            this.statusLabel.setText("You Win!  : - )");
        } else {
            this.statusLabel.setForeground(Color.red);
            this.statusLabel.setText("You Lose  : - (");
        }
    }

    public static void main(String[] stringArray) {
        minesweeperGUI minesweeperGUI2 = new minesweeperGUI();
        minesweeperGUI2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mineButton mineButton2 = (mineButton)mouseEvent.getSource();
        if (mouseEvent.getButton() == 1) {
            this.game.markTile(mineButton2.getRow(), mineButton2.getCol(), 0);
        } else if (mouseEvent.getButton() == 3) {
            switch (this.game.getTiles(mineButton2.getRow(), mineButton2.getCol())) {
                case 1: {
                    this.game.markTile(mineButton2.getRow(), mineButton2.getCol(), 3);
                    break;
                }
                case 3: {
                    this.game.markTile(mineButton2.getRow(), mineButton2.getCol(), 2);
                    break;
                }
                case 2: {
                    this.game.markTile(mineButton2.getRow(), mineButton2.getCol(), 1);
                }
            }
        }
        this.updateGame();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class mineButton
    extends JButton {
        int r;
        int c;

        public mineButton(int n, int n2) {
            this.r = n;
            this.c = n2;
        }

        public int getRow() {
            return this.r;
        }

        public int getCol() {
            return this.c;
        }
    }
}

