package ir.classifiers;

import java.util.*;
import ir.vsr.*;
import ir.utilities.*;

/**
 * An individual perceptron object used by the Perceptron classifier
 * Includes methods for classifying an Example and training the
 * unit to fire only for a given category of examples.
 *
 * @author       Ray Mooney
 */

public class PerceptronUnit
{
    /** The threshold of the perceptron. The net input must exceed this
     * threshold in order for the neuron to fire */
    protected double threshold = 0.0;

    /** The weights of the perceptron.  Since the weight vector is sparse,
     * most entries are zero, a HashMapVector is used to store the weights
     * for the non-zero features (tokens). See ir.vsr.HashMapVector. */
    protected HashMapVector weights = new HashMapVector();

    /** Maximum number of training epochs allowed */
    public int maxEpochs = 100;

    /** The learning rate for weight updating */
    public double learningRate = 0.1;

    /** Array of categories (classes) in the data */
    protected String[] categories;

    /** Flag for debug print statements */
    public boolean debug = false;

    /** Create an PerceptronUnit with these attributes
     *
     * @param categories  The array of Strings containing the category names
     * @param debug  Flag to turn on detailed output
     */
    public PerceptronUnit(String [] categories, boolean debug) {
	this.categories = categories;
	this.debug = debug;
    }

    /** Clear the weights and threshold all back to zero */
    public void clear() {
	threshold = 0.0;
	weights.clear();
    }

    /** Classify an example using the perceptron and return the
     * amount by which the net input exceeds the threshold as
     * a measure of confidence of the prediction of being positive
     * for this perceptron */
    public double classify(Example example) {
	// You must implement
	return 0; // dummy output
    }

    /** Trains the perceptron to only fire for examples in the given category, i.e.
     * examples in the given category should be treated as positive examples for this
     * perceptron and examples in all other categories should be treated as negative */
    public void trainCategory(List trainExamples, int category) {
	// You must implement
    }


}

