package ir.classifiers;

import java.util.*;

/**
 * Wrapper class to test Perceptron classifier using 10-fold CV.
 * Running it with -debug option gives very detailed output
 * @author       Ray Mooney
 */

public class TestPerceptron {
    public static void main(String args[]) throws Exception
    {
	String dirName = "/u/mooney/ir-code/corpora/yahoo-science/";
	String[] categories = {"bio","chem","phys"};
	System.out.println("\nLoading Examples ...");
	List<Example> examples = new DirectoryExamplesConstructor(dirName, categories).getExamples();
	System.out.println("\nInitializing Perceptron classifier ...");
	boolean debug;
	// setting debug flag gives very detailed output, suitable for debugging
	if (args.length==1 && args[0].equals("-debug"))
	    debug = true;
	else
	    debug = false;
	Perceptron perceptron = new Perceptron(categories, debug);

	// Perform 10-fold cross validation to generate learning curve
	CVLearningCurve cvCurve = new CVLearningCurve(perceptron,examples);
	cvCurve.run();
    }
}
