package ir.utilities;

import java.lang.StringBuffer;
import java.util.*;
import java.io.*;

/**
 * A place to put some additional string functions
 *
 * @author Ray Mooney
 */

public class MoreString {

  /**
   * Pad a string with a specific char on the right to make it the specified length
   */
  public static String padTo(String string, int length, char ch) {
    if (string.length() >= length)
      return string;
    StringBuffer stringBuf = new StringBuffer(string);
    stringBuf.setLength(length);
    for (int i = string.length(); i < length; i++)
      stringBuf.setCharAt(i, ch);
    return stringBuf.toString();
  }

  /**
   * Pad a string with blanks on the right to make it the specified length
   */
  public static String padTo(String string, int length) {
    return padTo(string, length, ' ');
  }

  /**
   * Pad a string with a specific char on the left to make it the specified length
   */
  public static String padToLeft(String string, int length, char ch) {
    if (string.length() >= length)
      return string;
    StringBuffer stringBuf = new StringBuffer(length);
    for (int i = 0; i < (length - string.length()); i++)
      stringBuf.append(ch);
    stringBuf.append(string);
    return stringBuf.toString();
  }

  /**
   * Pad a string with blanks on the left to make it the specified length
   */
  public static String padToLeft(String string, int length) {
    return padToLeft(string, length, ' ');
  }

  /**
   * Convert a double to a string and pad with blanks on the left
   * to make it the specified length
   */
  public static String padToLeft(double x, int length) {
    return padToLeft(Double.toString(x), length);
  }

  /**
   * Convert an int to a string and pad with blanks on the left
   * to make it the specified length
   */
  public static String padToLeft(int x, int length) {
    return padToLeft(Integer.toString(x), length);
  }

  public static String padWithZeros(int x, int length) {
    return padToLeft(Integer.toString(x), length, '0');
  }

  public static String padWithZeros(double x, int length) {
    return padToLeft(Double.toString(x), length, '0');
  }

  /**
   * Segment a string into substrings by breaking at occurences of the given
   * character and returning a list of segments
   */
  public static ArrayList<String> segment(String string, char ch) {
    ArrayList<String> result = new ArrayList<String>();
    String segment = null;
    int pos = 0; // The start position of the current segment
    for (int i = 0; i < string.length(); i++) {
      // If find breaking char at this point
      if (string.charAt(i) == ch) {
        // Create a segment from pos to this point
        segment = string.substring(pos, i);
        // Unless empty, add to list of segments
        if (!segment.equals(""))
          result.add(segment);
        // Update start position of next segment
        pos = i + 1;
      }
    }
    // Include last segment for pos to end of string
    if (pos != string.length())
      result.add(string.substring(pos, string.length()));
    return result;
  }
  
  /** Segment a string into substrings by breaking at occurrences of the given
   * character and returning an array of all the segments, in order */
  public static String[] segmentToArray(String string, char ch) {
	ArrayList<String> list = segment(string, ch);
	return (String[])list.toArray(new String[0]);
  }

  public static int indexOfIgnoreCase(String string, String substring, int fromIndex) {
    for (int i = fromIndex; i < string.length(); i++) {
      if (startsWithIgnoreCase(string, substring, i))
        return i;
    }
    return -1;
  }

  public static int indexOfIgnoreCase(String string, String substring) {
    return indexOfIgnoreCase(string, substring, 0);
  }

  public static boolean startsWithIgnoreCase(String string, String substring, int fromIndex) {
    if ((fromIndex < 0) || ((fromIndex + substring.length()) > string.length()))
      return false;
    for (int i = 0; i < substring.length(); i++)
      if (Character.toUpperCase(string.charAt(fromIndex + i)) != Character.toUpperCase(substring.charAt(i)))
        return false;
    return true;
  }

  public static boolean startsWithIgnoreCase(String string, String substring) {
    return startsWithIgnoreCase(string, substring, 0);
  }
  
  /** Version of String method indexOf that treats all whitespace characters as equivalent
   * and matches lowercase characters in the substring to either lower or uppercase in the string,
   * but uppercase characters in the substring must match uppercase in the string */
  public static int indexOfPhrase(String string, String substring, int fromIndex) {
	for(int i = fromIndex; i < string.length(); i++) {
	    if (startsWithPhrase(string, substring, i))
		return i;
	}
	return -1;
  }
  
  /** Version of String method indexOf that treats all whitespace characters in substring
   * as matching any "word boundary" and matches lowercase characters in the substring to either lower 
   * or uppercase in the string, but uppercase characters in the substring must match uppercase in the string */
  public static int indexOfPhrase(String string, String substring) {
	return indexOfPhrase(string, substring, 0);
  }
  
  /** Version of String method startsWith that treats all whitespace characters in substring
   * as matching any "word boundary" and matches lowercase characters in the substring to either lower 
   * or uppercase in the string, but uppercase characters in the substring must match uppercase in the string */
  public static boolean startsWithPhrase(String string, String substring, int fromIndex) {
	if ((fromIndex < 0) || ((fromIndex + substring.length()) > string.length()))
	    return false;
	for(int i = 0; i < substring.length(); i++) 
	    if (Character.isWhitespace(substring.charAt(i))) {
		if (!isWordBoundary(string.charAt(fromIndex + i)))
		    return false;
	    }
	    else {
		if (Character.isUpperCase(substring.charAt(i))) {
		    if (string.charAt(fromIndex + i) != substring.charAt(i))
			return false;
		}
		else
		    if (Character.toUpperCase(string.charAt(fromIndex + i)) != 
			Character.toUpperCase(substring.charAt(i)))
			return false;
	    }
	return true;
  }

  /** Version of String method startsWith that treats all whitespace characters in substring
   * as matching any "word boundary" and matches lowercase characters in the substring to either lower 
   * or uppercase in the string, but uppercase characters in the substring must match uppercase in the string */
  public static boolean startsWithPhrase(String string, String substring) {
	return startsWithPhrase(string, substring, 0);
  }
  
  /** Returns true iff character is in a specific set considered to mark a word boundary */
  public static boolean isWordBoundary(char x) {
	if (Character.isWhitespace(x))
	    return true;
	switch(x) {
	  case '<':
	  case '>':    
	  case '(':
	  case ')':
	  case '[':
	  case ']':
	  case '{':
	  case '}':
	  case ',':
	  case '.':
	  case '?':
	  case '!':
	  case ';':
	  case ':':
	  case '\"':
	  case '\'':
	  case '/':
	  case '-':
	  case '_':
	  case '&':
	      return true;
	default: return false;
	}
  }
  
  /** Counts the number of times that a given substring appears in a string using
   * matching as defined in startsWithPhrase and starting in the string from fromIndex */
  public static int countPhrase(String string, String substring, int fromIndex) {
	int count = 0;
	if (string == null || substring == null)
	    return 0;
	for(int i = fromIndex; i < string.length(); i++) {
	    if (startsWithPhrase(string, substring, i))
		count++;
	}
	return count;
  }

  /** Counts the number of times that a given substring appears in a string using
   * matching as defined in startsWithPhrase */
  public static int countPhrase(String string, String substring) {
	return countPhrase(string, substring, 0);
  }

  public static String fileExtension(String fileName) {
    int pos = fileName.lastIndexOf(".");
    if (pos == -1)
      return "";
    else
      return fileName.substring(pos + 1);
  }

  /**
   * Load the stopwords from file to the hashtable where they are indexed.
   */
  public static String fileToString(String fileName) {
    StringBuffer stringBuf = new StringBuffer();
    String line;
    try {
      BufferedReader in = new BufferedReader(new FileReader(fileName));
      // Read in file, one per line, until file is empty
      while ((line = in.readLine()) != null) {
        stringBuf.append(line);
        stringBuf.append("\n");
      }
      in.close();
    }
    catch (IOException e) {
      System.out.println("\nCould not load file: " + fileName);
      System.exit(1);
    }
    return stringBuf.toString();
  }

  public static void main(String[] args) {
    System.out.println(fileToString(args[0]));
  }

}

