package ir.webutils;

import java.net.*;

/**
 * Link with included anchor text
 *
 * @author Ray Mooney */

public class AnchoredLink extends Link {

    /** Anchor text for this link */
    private String anchorText = null;

    /** Constructs a link with specified URL and anchor text */
    public AnchoredLink(URL url, String anchorText) {
	super(url);
	this.anchorText = anchorText;
    }

    /** Constructs a link with specified URL */
    public AnchoredLink(URL url) {
	this(url, null);
    }

    /** Construct a link with specified URL string */
    public AnchoredLink(String urlName) {
	super(urlName);
    }
    
    /** Return anchor text for link */
    public String getAnchorText() {
	return anchorText;
    }
 
   /** Return anchor text for link */
    public void setAnchorText(String text) {
	anchorText = text;
    }
    
    @Override
    public double getScore()
    {
    	return 0;
    }
    
    public String toString() {
	return "<a href=\"" + getURL() + "\">" + anchorText + "</a>";
    }
}

