package ir.webutils;

import ir.utilities.*;

/**
 * Object for defining the goal in a heuristic web search.
 * Default version checks if page contains all of a set of
 * "want strings"
 *
 * @author Ray Mooney */

public class PageGoal extends Object {

    /** Array of strings to be found on a web page*/
    String[] wantStrings;
    
    /** Construct a PageGoal with these wantStrings */
    public PageGoal(String[] wantStrings) {
	this.wantStrings = wantStrings;
    }

    /** Returns true if this page satisfies the goal by containing
     * all of the wantStrings */
    public boolean satisfiedBy(HTMLPage page) {
	for(int i = 0; i < wantStrings.length; i++) {
	    // If any of the strings are not found in the page, then return false
	    if (MoreString.indexOfPhrase(page.getText(), wantStrings[i]) == -1)
		return false;
	}
	// If reach here, all the strings must have been found in the page
	return true;
    }

}
    
	
