package ir.webutils;

import java.net.*;

/**
 * An AnchoredLink that can be used in heuristic web search where links
 * are scored for their promise. ScoredAnchoredLink's can be compared
 * where HIGHER scores are preferable (appear earlier in a sort). 
 *
 * @author Ray Mooney */

public class ScoredAnchoredLink extends AnchoredLink {

    /** The heuristic score assigned to this link */
    public double score = -1;

    /** The heuristic score assigned to the page to which this link points*/
    public double pageScore = -1;

    /** A pointer back to the link to the page from which the current link was extracted.
     * Therefore the pageScore of the backLink is the score of the page on which the
     * current link appears */
    ScoredAnchoredLink backLink = null;
    
    /** Character position of start of link on text of web page */
    int startPosition = -1;

    /** Character position of end of link on text of web page */
    int endPosition = -1;

    /** Constructs a link with specified URL and anchor text and backLink */
    public ScoredAnchoredLink(URL url, String anchorText, Link backLink, int startPosition) {
	super(url, anchorText);
	this.backLink = (ScoredAnchoredLink)backLink;
	this.startPosition = startPosition;
    }

    /** Constructs a link with specified URL and backLink*/
    public ScoredAnchoredLink(URL url, Link backLink, int startPosition) {
	this(url, null, backLink, startPosition);
    }
    
    /** Construct a link with specified URL string */
    public ScoredAnchoredLink(String urlName) {
	super(urlName);
    }

    /** Return backLink for link */
    public ScoredAnchoredLink getBackLink() {
	return backLink;
    }

 
    /** Return startPosition for link */
    public int getStartPosition() {
	return startPosition;
    }

    /** Return endPosition for link */
    public int getEndPosition() {
	return endPosition;
    }
 
    /** Set endPosition for link */
    public void setEndPosition(int endPosition) {
	this.endPosition = endPosition;
    }

    @Override
    public double getScore()
    {
    	return score;
    }
    
    /*
    public int compareTo(Object obj) {
	ScoredAnchoredLink link = (ScoredAnchoredLink)obj;
	if (score == link.score) 
	    return 0;
	else if (score > link.score) 
	    return -1;
	else return 1;
    }*/

    

}

