;; Formalization of the Observation property

(in-package "ACL2")

(include-book "executions")
(include-book "no-thin-air")

(encapsulate
 (((prop * *) => *))
 
 (local (defun prop (x y) (declare (ignore x y)) nil))

 (defthm prop-write-write
   (implies (prop x y)
            (and (writep x) (writep y)))
   :rule-classes :forward-chaining))

(defun fre (x y)
  (and (fr x y)
       (not (equal (proc x) (proc y)))))

(defun-sk hb+ (x y)
  (exists path
          (hb-pathp path x y)))

(defun hb* (x y)
  (or (equal x y)
      (hb+ x y)))

(defun-sk fre->prop->hb* (x y)
  (exists (w1 w2)
          (and (fre x w1)
               (prop w1 w2)
               (hb* w2 y))))

(defun-sk obs ()
  (forall x
          (not (fre->prop->hb* x x))))
