;; Formalization of the No Thin Air property

(in-package "ACL2")

(include-book "executions")

(encapsulate
 (((ppo * *) => *)
  ((fences * *) => *))

  (local (defun ppo (x y) (po x y)))
  (local (defun fences (x y) (declare (ignore x y)) nil))

  (defthm ppo-in-po
    (implies (ppo x y) (po x y)))

  (defthm fences-read-or-write
    (implies (fences x y)
             (and (or (readp x) (writep x))
                  (or (readp y) (writep y))))
    :rule-classes :forward-chaining))

(defun rfe (x y)
  (and (rf x y)
       (not (equal (proc x) (proc y)))))

(defun hb (x y)
  (or (ppo x y)
      (fences x y)
      (rfe x y)))

(defun hb-pathp (path x y)
  (cond ((endp path) (hb x y))
        (t (and (hb x (car path))
                (hb-pathp (cdr path) (car path) y)))))

(defun hb-cyclep (cycle x)
  (hb-pathp cycle x x))

(defun-sk no-thin-air ()
  (forall (x potential-cycle)
          (not (hb-cyclep potential-cycle x))))
