;; Formalization of the Observation property

(in-package "ACL2")

(include-book "executions")
(include-book "no-thin-air")
(include-book "observation")

(defun co-prop (x y)
  (or (co x y) (prop x y)))


(defun co-prop-pathp (path x y)
  (cond ((endp path) (co-prop x y))
        (t (and (co-prop x (car path))
                (co-prop-pathp (cdr path) (car path) y)))))

(defun co-prop-cyclep (cycle x)
  (co-prop-pathp cycle x x))

(defun-sk propagation ()
  (forall (x cycle)
          (not (co-prop-cyclep cycle x))))
