#!/bin/csh -f

set tgtdir = $argv[1]
set srcdir = $argv[2]/$tgtdir

# The following rather odd way to get the files of interest is constructed in
# order to avoid getting any error output.  It would be great to be taught a
# better way.  We expect $files to be free of directory names.

set files = (`ls -1 $srcdir | grep '[.]lisp$'`)
set files = (`ls -1 $srcdir | grep '[.]lsp$'` $files)
set files = (`ls -1 $srcdir | grep '[.]acl2$'` $files)
set files = (`ls -1 $srcdir | grep ^Makefile$` $files)
set files = (`ls -1 $srcdir | grep ^README$` $files)

cd $tgtdir

echo "Entering `pwd`"

foreach file ($files)
    if (! (-f $file)) then
	set cmd = "ln -s $srcdir/$file ."
	echo $cmd
	$cmd
    endif
end
